/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ModifyMageAction
extends BaseSpellAction {
    private String mageClass;
    private ModifyType modifyType;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.mageClass = parameters.getString("mage_class", "");
        String modifyTypeString = parameters.getString("modify_type", "activate");
        try {
            this.modifyType = ModifyType.valueOf(modifyTypeString.toUpperCase());
        }
        catch (Exception ex) {
            context.getLogger().warning("Invalid ModifyMage modify_type: " + String.valueOf((Object)this.modifyType));
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.modifyType == null || this.mageClass.isEmpty()) {
            return SpellResult.FAIL;
        }
        Entity target = context.getTargetEntity();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (!(target instanceof Player)) {
            return SpellResult.PLAYER_REQUIRED;
        }
        MageController controller = context.getController();
        Mage mage = controller.getMage(target);
        switch (this.modifyType.ordinal()) {
            case 0: {
                if (mage.setActiveClass(this.mageClass)) break;
                return SpellResult.FAIL;
            }
            case 4: {
                MageClass targetClass = mage.unlockClass(this.mageClass);
                if (targetClass == null) {
                    return SpellResult.FAIL;
                }
                if (mage.setActiveClass(this.mageClass)) break;
                return SpellResult.FAIL;
            }
            case 2: {
                MageClass targetClass = mage.unlockClass(this.mageClass);
                if (targetClass != null) break;
                return SpellResult.FAIL;
            }
            case 1: {
                if (mage.lockClass(this.mageClass)) break;
                return SpellResult.FAIL;
            }
            case 3: {
                MageClass targetClass;
                MageClass activeClass = mage.getActiveClass();
                if (activeClass != null) {
                    mage.lockClass(activeClass.getKey());
                }
                if ((targetClass = mage.unlockClass(this.mageClass)) == null) {
                    if (activeClass != null) {
                        mage.unlockClass(activeClass.getKey());
                    }
                    return SpellResult.FAIL;
                }
                if (mage.setActiveClass(this.mageClass)) break;
                return SpellResult.FAIL;
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("mage_class");
        parameters.add("modify_type");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("modify_type")) {
            for (ModifyType modifyType : ModifyType.values()) {
                examples.add(modifyType.name().toLowerCase());
            }
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    public static enum ModifyType {
        ACTIVATE,
        LOCK,
        UNLOCK,
        SWITCH,
        UNLOCK_AND_ACTIVATE;

    }
}

