/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.npc.MagicNPC;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;

public class RemoveNPCAction
extends BaseSpellAction {
    private UUID npcId;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        String idString = parameters.getString("npc_id");
        if (idString != null && !idString.isEmpty()) {
            try {
                this.npcId = UUID.fromString(idString);
            }
            catch (Exception ex) {
                context.getLogger().warning("Invalid npc_id: " + idString);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.npcId == null) {
            return SpellResult.FAIL;
        }
        MageController controller = context.getController();
        MagicNPC npc = controller.getNPC(this.npcId);
        if (npc == null) {
            return SpellResult.NO_TARGET;
        }
        controller.removeNPC(npc);
        return SpellResult.CAST;
    }
}

