/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;

public class SkipAction
extends CompoundAction {
    private int skipCount;
    private int skipCounter;
    private int skipDuration;
    private boolean repeatSkip;
    private long targetTime;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.skipDuration = parameters.getInt("until", 0);
        this.skipCount = parameters.getInt("skip", this.skipDuration > 0 ? 0 : 1);
        this.repeatSkip = parameters.getBoolean("repeat_skip", true);
        this.skipCounter = 0;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.targetTime = 0L;
    }

    @Override
    public SpellResult step(CastContext context) {
        if (this.targetTime == 0L && this.skipDuration > 0) {
            this.targetTime = System.currentTimeMillis() + (long)this.skipDuration;
            return SpellResult.NO_ACTION;
        }
        if (this.skipDuration > 0 && System.currentTimeMillis() < this.targetTime) {
            return SpellResult.NO_ACTION;
        }
        if (this.skipCounter++ < this.skipCount) {
            return SpellResult.NO_ACTION;
        }
        if (this.repeatSkip) {
            this.skipCounter = 0;
            this.targetTime = 0L;
        }
        return this.startActions();
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("skip");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        super.getParameterOptions(spell, parameterKey, examples);
        if (parameterKey.equals("skip")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        }
    }
}

