/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.item.Cost;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class TakeCostsAction
extends CheckAction {
    private List<Cost> costs = null;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        ItemStack item;
        super.prepare(context, parameters);
        this.costs = Cost.parseCosts(ConfigurationUtils.getConfigurationSection(parameters, "costs"), context.getController());
        String itemKey = parameters.getString("item", "");
        if (parameters.getBoolean("item_cost") && !itemKey.isEmpty() && (item = context.getController().createItem(itemKey)) != null && !CompatibilityLib.getItemUtils().isEmpty(item)) {
            if (this.costs == null) {
                this.costs = new ArrayList<Cost>();
            }
            this.costs.add(new Cost(item));
        }
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        if (this.costs == null) {
            return true;
        }
        for (Cost cost : this.costs) {
            if (cost.has(context.getMage(), context.getWand(), null)) continue;
            String baseMessage = context.getMessage("insufficient");
            String costDescription = cost.getFullDescription(context.getController().getMessages(), null);
            costDescription = baseMessage.replace("$cost", costDescription);
            context.showMessage(costDescription);
            return false;
        }
        if (this.costs != null) {
            for (Cost cost : this.costs) {
                cost.deduct(context.getMage(), context.getWand(), null);
            }
        }
        return true;
    }
}

