/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TameAction
extends BaseSpellAction {
    private boolean own = true;
    private boolean persist = true;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.own = parameters.getBoolean("own", true);
        this.persist = parameters.getBoolean("persist", true);
    }

    @Override
    public SpellResult perform(CastContext context) {
        UUID existingOwner;
        EntityData mob;
        Player player = context.getMage().getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        Entity entity = context.getTargetEntity();
        boolean tamed = CompatibilityLib.getCompatibilityUtils().tame(entity, player);
        boolean owned = false;
        if (this.own && (mob = context.getController().getMob(entity)) != null && mob.isOwnable() && (existingOwner = CompatibilityLib.getCompatibilityUtils().getOwnerId(entity)) == null) {
            CompatibilityLib.getCompatibilityUtils().setOwner(entity, (Entity)player);
            owned = true;
        }
        if (tamed || owned) {
            if (this.persist) {
                CompatibilityLib.getCompatibilityUtils().setPersist(entity, true);
                CompatibilityLib.getCompatibilityUtils().setRemoveWhenFarAway(entity, false);
            }
            return SpellResult.CAST;
        }
        return SpellResult.NO_TARGET;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

