/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.magic;

import com.elmakers.mine.bukkit.api.magic.Messages;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public class MagicAttribute {
    @Nonnull
    private final String key;
    @Nullable
    private final Double defaultValue;
    @Nullable
    private final Double min;
    @Nullable
    private final Double max;
    @Nullable
    private final String iconKey;
    @Nullable
    private final String iconDisabledKey;
    private final boolean hidden;

    public MagicAttribute(@Nonnull String key, @Nonnull ConfigurationSection configuration) {
        this.key = key;
        this.min = configuration.contains("min") ? Double.valueOf(configuration.getDouble("min")) : null;
        this.max = configuration.contains("max") ? Double.valueOf(configuration.getDouble("max")) : null;
        this.defaultValue = configuration.contains("default") ? Double.valueOf(configuration.getDouble("default")) : null;
        this.iconKey = configuration.getString("icon");
        this.iconDisabledKey = configuration.getString("icon_disabled");
        this.hidden = configuration.getBoolean("hidden");
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public Double getDefault() {
        return this.defaultValue;
    }

    @Nullable
    public Double getMin() {
        return this.min;
    }

    @Nullable
    public Double getMax() {
        return this.max;
    }

    public boolean inRange(double value) {
        if (this.min != null && value < this.min) {
            return false;
        }
        return this.max == null || !(value > this.max);
    }

    @Nullable
    public String getIconKey() {
        return this.iconKey;
    }

    @Nullable
    public String getIconDisabledKey() {
        return this.iconDisabledKey;
    }

    public String getName(Messages messages) {
        return messages.get("attributes." + this.key + ".name", this.key);
    }

    public String getDescription(Messages messages) {
        return messages.get("attributes." + this.key + ".description", this.key);
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

