/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.spell;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PrerequisiteSpell {
    private final SpellKey spellKey;
    private final long progressLevel;

    public PrerequisiteSpell(String spellKey, long progressLevel) {
        this(new SpellKey(spellKey), progressLevel);
    }

    public PrerequisiteSpell(SpellKey spellKey, long progressLevel) {
        this.spellKey = spellKey;
        this.progressLevel = progressLevel;
    }

    public SpellKey getSpellKey() {
        return this.spellKey;
    }

    public long getProgressLevel() {
        return this.progressLevel;
    }

    public String toString() {
        return "PrerequisiteSpell{spellKey=" + this.spellKey.getKey() + ", progressLevel=" + this.progressLevel + "}";
    }

    public static Collection<PrerequisiteSpell> getMissingRequirements(CasterProperties caster, SpellTemplate spell) {
        ArrayList<PrerequisiteSpell> missingRequirements = new ArrayList<PrerequisiteSpell>(spell.getPrerequisiteSpells());
        if (caster == null) {
            return missingRequirements;
        }
        Iterator it = missingRequirements.iterator();
        while (it.hasNext()) {
            PrerequisiteSpell prereq = (PrerequisiteSpell)it.next();
            Spell mageSpell = caster.getSpell(prereq.getSpellKey().getKey());
            if (!PrerequisiteSpell.isSpellSatisfyingPrerequisite(mageSpell, prereq)) continue;
            it.remove();
        }
        return missingRequirements;
    }

    public static boolean hasPrerequisites(CasterProperties caster, SpellTemplate spell) {
        if (spell == null) {
            return true;
        }
        if (caster == null) {
            return false;
        }
        for (PrerequisiteSpell prereq : spell.getPrerequisiteSpells()) {
            Spell mageSpell = caster.getSpell(prereq.getSpellKey().getKey());
            if (PrerequisiteSpell.isSpellSatisfyingPrerequisite(mageSpell, prereq)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSpellSatisfyingPrerequisite(Spell spell, PrerequisiteSpell prerequisiteSpell) {
        if (spell == null) {
            return false;
        }
        if (!spell.getController().isSpellProgressionEnabled()) {
            return spell.getSpellKey().getLevel() >= prerequisiteSpell.getSpellKey().getLevel();
        }
        return spell.getSpellKey().getLevel() > prerequisiteSpell.getSpellKey().getLevel() || spell.getProgressLevel() >= prerequisiteSpell.getProgressLevel() && spell.getSpellKey().getLevel() == prerequisiteSpell.getSpellKey().getLevel();
    }
}

