/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.spell.builtin.SaveSchematicSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class SaveSchematicBatch
implements Batch,
SpellBatch {
    private static final int MAX_FILES = 1000;
    private final World world;
    private final TargetingSpell spell;
    private final CastContext context;
    private final MaterialSet ignore;
    private boolean finished = false;
    private String[][][] blockData;
    private String filename;
    private final int absx;
    private final int absy;
    private final int absz;
    private final int dx;
    private final int dy;
    private final int dz;
    private final int x;
    private final int y;
    private final int z;
    private int ix = 0;
    private int iy = 0;
    private int iz = 0;

    public SaveSchematicBatch(TargetingSpell spell, Location p1, Location p2, MaterialSet ignore) {
        this.spell = spell;
        this.context = spell.getCurrentCast();
        this.ignore = ignore;
        this.world = p1.getWorld();
        int deltax = p2.getBlockX() - p1.getBlockX();
        int deltay = p2.getBlockY() - p1.getBlockY();
        int deltaz = p2.getBlockZ() - p1.getBlockZ();
        this.absx = Math.abs(deltax) + 1;
        this.absy = Math.abs(deltay) + 1;
        this.absz = Math.abs(deltaz) + 1;
        this.blockData = new String[this.absx][this.absy][this.absz];
        this.dx = (int)Math.signum(deltax);
        this.dy = (int)Math.signum(deltay);
        this.dz = (int)Math.signum(deltaz);
        this.x = p1.getBlockX();
        this.y = p1.getBlockY();
        this.z = p1.getBlockZ();
    }

    @Override
    public int size() {
        return this.absx * this.absy * this.absz;
    }

    @Override
    public int remaining() {
        return (this.absx - this.ix) * (this.absy - this.iy) * (this.absz - this.iz);
    }

    public boolean checkDimension(int maxDimension) {
        return maxDimension <= 0 || this.absx <= maxDimension && this.absy <= maxDimension && this.absz <= maxDimension;
    }

    @Override
    public int process(int maxWork) {
        int workPerformed = 0;
        while (workPerformed <= maxWork && this.ix < this.absx) {
            Location location = new Location(this.world, (double)(this.x + this.ix * this.dx), (double)(this.y + this.iy * this.dy), (double)(this.z + this.iz * this.dz));
            if (!CompatibilityLib.getCompatibilityUtils().checkChunk(location)) {
                return workPerformed + 20;
            }
            Block block = location.getBlock();
            String data = "minecraft:air";
            if (this.ignore == null || !this.ignore.testBlock(block)) {
                data = CompatibilityLib.getCompatibilityUtils().getBlockData(block);
            }
            this.blockData[this.ix][this.iy][this.iz] = data;
            this.context.addResult(SpellResult.CAST);
            workPerformed += 10;
            ++this.iy;
            if (this.iy < this.absy) continue;
            this.iy = 0;
            ++this.iz;
            if (this.iz < this.absz) continue;
            this.iz = 0;
            ++this.ix;
        }
        if (this.ix >= this.absx) {
            if (!this.saveToFile()) {
                this.context.addResult(SpellResult.FAIL);
            }
            this.finish();
        }
        return workPerformed;
    }

    private boolean saveToFile() {
        boolean bl;
        int index;
        File schematicFolder = new File(this.context.getPlugin().getDataFolder(), "schematics");
        if (!schematicFolder.exists() && !schematicFolder.mkdirs()) {
            this.context.getLogger().warning("Could not create schematics folder: " + schematicFolder.getAbsolutePath());
            return false;
        }
        File targetFile = null;
        for (index = 1; (targetFile == null || targetFile.exists()) && index < 1000; ++index) {
            this.filename = this.context.getMage().getName().toLowerCase() + index + ".schem";
            targetFile = new File(schematicFolder, this.filename);
        }
        if (index >= 1000) {
            this.context.getMage().sendMessage(String.valueOf(ChatColor.RED) + "You have over 1000 schematics!");
            this.context.getMage().sendMessage(String.valueOf(ChatColor.YELLOW) + "Overwriting: " + String.valueOf(ChatColor.WHITE) + this.filename);
        }
        if (this.spell instanceof SaveSchematicSpell) {
            ((SaveSchematicSpell)this.spell).setFilename(this.filename);
        }
        FileOutputStream outputStream = new FileOutputStream(targetFile);
        try {
            bl = CompatibilityLib.getSchematicUtils().saveSchematic(outputStream, this.blockData);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                this.context.getLogger().log(Level.WARNING, "Failed to write to file: " + targetFile.getAbsolutePath());
                return false;
            }
        }
        outputStream.close();
        return bl;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            this.finished = true;
            if (this.context != null) {
                this.context.finish();
            }
        }
    }

    @Override
    public void cancel() {
        this.context.cancelEffects();
        this.spell.cancel();
        this.finish();
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public Spell getSpell() {
        return this.spell;
    }

    @Override
    public String getName() {
        return this.spell.getName();
    }

    @Override
    public UndoList getUndoList() {
        return null;
    }
}

