/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import org.bukkit.block.Block;
import org.bukkit.util.BlockVector;

public abstract class VolumeBatch
implements Batch {
    protected final MageController controller;
    private String worldName;
    protected boolean finished = false;
    private Integer minx = null;
    private Integer miny = null;
    private Integer minz = null;
    private Integer maxx = null;
    private Integer maxy = null;
    private Integer maxz = null;

    public VolumeBatch(MageController controller) {
        this.controller = controller;
        this.worldName = null;
    }

    protected void updateBlock(BlockData data) {
        BlockVector location = data.getPosition();
        this.updateBlock(data.getWorldName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    protected void updateBlock(Block block) {
        this.updateBlock(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    protected void updateBlock(String worldName, int x, int y, int z) {
        if (this.worldName != null && !this.worldName.equals(worldName)) {
            return;
        }
        if (this.worldName == null) {
            this.worldName = worldName;
        }
        if (this.minx == null) {
            this.minx = x;
            this.miny = y;
            this.minz = z;
            this.maxx = x;
            this.maxy = y;
            this.maxz = z;
        } else {
            this.minx = Math.min(x, this.minx);
            this.miny = Math.min(z, this.miny);
            this.minz = Math.min(z, this.minz);
            this.maxx = Math.max(x, this.maxx);
            this.maxy = Math.max(z, this.maxy);
            this.maxz = Math.max(z, this.maxz);
        }
    }

    @Override
    public void finish() {
        if (!this.finished) {
            if (this.worldName != null && this.minx != null && this.miny != null && this.minz != null && this.maxx != null && this.maxy != null && this.maxz != null) {
                this.controller.updateVolume(this.worldName, this.minx, this.miny, this.minz, this.maxx, this.maxy, this.maxz);
            }
            this.finished = true;
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }
}

