/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.MaterialSetManager;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.materials.MaterialSets;
import com.elmakers.mine.bukkit.utility.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;

public class DefaultMaterials {
    private static DefaultMaterials instance;
    private MaterialSet commandBlocks = MaterialSets.empty();
    private MaterialSet halfBlocks = MaterialSets.empty();
    private MaterialSet water = MaterialSets.empty();
    private MaterialSet lava = MaterialSets.empty();
    private MaterialSet skulls = MaterialSets.empty();
    private MaterialSet playerSkulls = MaterialSets.empty();
    private MaterialSet banners = MaterialSets.empty();
    private MaterialSet signs = MaterialSets.empty();
    private MaterialSet saplings = MaterialSets.empty();
    private MaterialSet air = MaterialSets.empty();
    private MaterialSet shulkerBoxes = MaterialSets.empty();
    private MaterialAndData playerSkullItem = null;
    private MaterialAndData playerSkullWallBlock = null;
    private MaterialAndData skeletonSkullItem = null;
    private Material groundSignBlock = null;
    private Material wallSignBlock = null;
    private Material firework = null;
    private Material fireworkStar = null;
    private Material mobSpawner = null;
    private Material filledMap = null;
    private Material netherPortal = null;
    private Material writeableBook = null;
    private MaterialAndData wallTorch = null;
    private MaterialAndData redstoneTorchOn = null;
    private MaterialAndData redstoneTorchOff = null;
    private MaterialAndData redstoneWallTorchOn = null;
    private MaterialAndData redstoneWallTorchOff = null;
    private Map<Material, Map<DyeColor, MaterialAndData>> materialColors = new HashMap<Material, Map<DyeColor, MaterialAndData>>();
    private Map<Material, Material> colorMap = new HashMap<Material, Material>();
    private Map<Material, Material> blockItems = new HashMap<Material, Material>();
    private Map<String, Biome> biomeMap = new HashMap<String, Biome>();
    private Map<Material, List<Material>> materialVariants = new HashMap<Material, List<Material>>();
    private Map<Material, Material> variantMap = new HashMap<Material, Material>();

    private DefaultMaterials() {
    }

    public static DefaultMaterials getInstance() {
        if (instance == null) {
            instance = new DefaultMaterials();
        }
        return instance;
    }

    public void initialize(MaterialSetManager manager) {
        this.commandBlocks = manager.getMaterialSet("commands");
        this.water = manager.getMaterialSet("all_water");
        this.lava = manager.getMaterialSet("all_lava");
        this.air = manager.getMaterialSet("all_air");
        this.halfBlocks = manager.getMaterialSet("half");
        this.skulls = manager.getMaterialSet("skulls");
        this.playerSkulls = manager.getMaterialSet("player_skulls");
        this.banners = manager.getMaterialSet("banners");
        this.signs = manager.getMaterialSet("signs");
        this.saplings = manager.getMaterialSet("saplings");
        this.shulkerBoxes = manager.getMaterialSet("shulker_boxes");
    }

    public void loadColors(Collection<ConfigurationSection> colors) {
        for (ConfigurationSection colorSection : colors) {
            Material keyColor = null;
            HashMap<DyeColor, MaterialAndData> newColors = new HashMap<DyeColor, MaterialAndData>();
            for (DyeColor color : DyeColor.values()) {
                String materialName;
                String colorName = color.name().toLowerCase();
                if (colorName.equals("silver")) {
                    colorName = "light_gray";
                }
                if ((materialName = colorSection.getString(colorName)) == null || materialName.isEmpty()) break;
                MaterialAndData parsed = null;
                parsed = new MaterialAndData(materialName.toUpperCase());
                if (!parsed.isValid()) break;
                newColors.put(color, parsed);
                if (keyColor != null) continue;
                keyColor = parsed.getMaterial();
            }
            if (newColors.size() != DyeColor.values().length) continue;
            this.materialColors.put(keyColor, newColors);
            for (MaterialAndData mat : newColors.values()) {
                this.colorMap.put(mat.getMaterial(), keyColor);
            }
        }
    }

    public void loadVariants(Collection<Object> variantLists) {
        for (Object rawList : variantLists) {
            if (!(rawList instanceof List)) continue;
            List variantList = (List)rawList;
            Material baseVariant = null;
            ArrayList<Material> materialList = new ArrayList<Material>();
            for (String materialKey : variantList) {
                try {
                    Material material = Material.getMaterial((String)materialKey.toUpperCase());
                    if (baseVariant == null) {
                        baseVariant = material;
                    }
                    this.variantMap.put(material, baseVariant);
                    materialList.add(material);
                }
                catch (Exception exception) {}
            }
            if (baseVariant == null) continue;
            this.materialVariants.put(baseVariant, materialList);
        }
    }

    public void setGroundSignBlock(Material material) {
        this.groundSignBlock = material;
    }

    @Nullable
    public static Material getGroundSignBlock() {
        return DefaultMaterials.getInstance().groundSignBlock;
    }

    public void setWallSignBlock(Material material) {
        this.wallSignBlock = material;
    }

    @Nullable
    public static Material getWallSignBlock() {
        return DefaultMaterials.getInstance().wallSignBlock;
    }

    public void setFirework(Material material) {
        this.firework = material;
    }

    @Nullable
    public static Material getFirework() {
        return DefaultMaterials.getInstance().firework;
    }

    @Nullable
    public static Material getFireworkStar() {
        return DefaultMaterials.getInstance().fireworkStar;
    }

    public void setFireworkStar(Material material) {
        this.fireworkStar = material;
    }

    public void setMobSpawner(Material material) {
        this.mobSpawner = material;
    }

    @Nullable
    public static Material getNetherPortal() {
        return DefaultMaterials.getInstance().netherPortal;
    }

    public void setNetherPortal(Material material) {
        this.netherPortal = material;
    }

    @Nullable
    public static Material getWriteableBook() {
        return DefaultMaterials.getInstance().writeableBook;
    }

    public void setWriteableBook(Material material) {
        this.writeableBook = material;
    }

    @Nullable
    public static Material getMobSpawner() {
        return DefaultMaterials.getInstance().mobSpawner;
    }

    public void setFilledMap(Material material) {
        this.filledMap = material;
    }

    @Nullable
    public static Material getFilledMap() {
        return DefaultMaterials.getInstance().filledMap;
    }

    public void setPlayerSkullItem(MaterialAndData item) {
        this.playerSkullItem = item;
    }

    @Nullable
    public static MaterialAndData getPlayerSkullItem() {
        return DefaultMaterials.getInstance().playerSkullItem;
    }

    public void setPlayerSkullWallBlock(MaterialAndData item) {
        this.playerSkullWallBlock = item;
    }

    @Nullable
    public static MaterialAndData getPlayerSkullWallBlock() {
        return DefaultMaterials.getInstance().playerSkullWallBlock;
    }

    public void setSkeletonSkullItem(MaterialAndData item) {
        this.skeletonSkullItem = item;
    }

    @Nullable
    public static MaterialAndData getSkeletonSkullItem() {
        return DefaultMaterials.getInstance().skeletonSkullItem;
    }

    public void loadBiomeMap(ConfigurationSection biomeConfig) {
        this.biomeMap.clear();
        if (biomeConfig == null) {
            return;
        }
        Set biomeKeys = biomeConfig.getKeys(false);
        for (String biomeKey : biomeKeys) {
            try {
                String value = biomeConfig.getString(biomeKey);
                Biome biome = Biome.valueOf((String)value.toUpperCase());
                this.biomeMap.put(biomeKey.toUpperCase(), biome);
            }
            catch (Exception exception) {}
        }
    }

    public void loadBlockItems(ConfigurationSection blocks) {
        Set blockKeys = blocks.getKeys(false);
        for (String blockKey : blockKeys) {
            try {
                Material blockMaterial = Material.getMaterial((String)blockKey.toUpperCase());
                String itemKey = blocks.getString(blockKey);
                Material itemMaterial = Material.getMaterial((String)itemKey.toUpperCase());
                this.blockItems.put(blockMaterial, itemMaterial);
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    public static Material getBaseColor(@Nullable Material material) {
        return material == null ? null : DefaultMaterials.getInstance().colorMap.get(material);
    }

    @Nullable
    public Material getBaseMaterial(@Nullable Material material) {
        block0: {
            Material m;
            Iterator<Material> iterator;
            Material material2 = material = material == null ? null : this.colorMap.get(material);
            if (material != null || this.colorMap.size() <= 0 || !(iterator = this.colorMap.values().iterator()).hasNext()) break block0;
            material = m = iterator.next();
        }
        return material;
    }

    public void colorize(@Nonnull MaterialAndData materialAndData, @Nonnull DyeColor color) {
        Material material = this.colorMap.get(materialAndData.getMaterial());
        if (material == null) {
            return;
        }
        Map<DyeColor, MaterialAndData> materialMap = this.materialColors.get(material);
        if (materialMap == null) {
            return;
        }
        MaterialAndData colored = materialMap.get(color);
        if (colored != null) {
            materialAndData.material = colored.material;
            materialAndData.data = colored.data;
        }
    }

    public static Collection<MaterialAndData> getColorBlocks(Material base) {
        return DefaultMaterials.getInstance().materialColors.get(base).values();
    }

    @Nullable
    public static Material getBaseVariant(@Nullable Material material) {
        return material == null ? null : DefaultMaterials.getInstance().variantMap.get(material);
    }

    @Nullable
    private Biome getSingleBiome(String biomeKey) {
        Biome biome = this.biomeMap.get(biomeKey = biomeKey.toUpperCase());
        if (biome == null) {
            try {
                biome = Biome.valueOf((String)biomeKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return biome;
    }

    @Nullable
    public Biome getBiome(String biomeKey) {
        String[] biomeKeys;
        if (biomeKey == null) {
            return null;
        }
        if ((biomeKey = biomeKey.trim()).isEmpty()) {
            return null;
        }
        for (String singleKey : biomeKeys = StringUtils.split(biomeKey, ",")) {
            Biome biome = this.getSingleBiome(singleKey);
            if (biome == null) continue;
            return biome;
        }
        return null;
    }

    @Nullable
    public static Collection<Material> getVariants(Material base) {
        return DefaultMaterials.getInstance().materialVariants.get(base);
    }

    public Collection<Map<DyeColor, MaterialAndData>> getAllColorBlocks() {
        return this.materialColors.values();
    }

    public Collection<List<Material>> getAllVariants() {
        return this.materialVariants.values();
    }

    public static boolean isCommand(Material material) {
        return DefaultMaterials.getInstance().commandBlocks.testMaterial(material);
    }

    public static boolean isHalfBlock(Material material) {
        return DefaultMaterials.getInstance().halfBlocks.testMaterial(material);
    }

    public static boolean isWater(Material material) {
        return DefaultMaterials.getInstance().water.testMaterial(material);
    }

    public static boolean isLava(Material material) {
        return DefaultMaterials.getInstance().lava.testMaterial(material);
    }

    public static boolean isPlayerSkull(MaterialAndData materialAndData) {
        return DefaultMaterials.getInstance().playerSkulls.testMaterialAndData(materialAndData);
    }

    public static boolean isShulkerBox(Material material) {
        return DefaultMaterials.getInstance().shulkerBoxes.testMaterial(material);
    }

    public static boolean isSkull(Material material) {
        return DefaultMaterials.getInstance().skulls.testMaterial(material);
    }

    public static boolean isBanner(Material material) {
        return DefaultMaterials.getInstance().banners.testMaterial(material);
    }

    public static boolean isSign(Material material) {
        return DefaultMaterials.getInstance().signs.testMaterial(material);
    }

    public static boolean isSapling(Material material) {
        return DefaultMaterials.getInstance().saplings.testMaterial(material);
    }

    public static boolean isMobSpawner(Material material) {
        return DefaultMaterials.getInstance().mobSpawner == material;
    }

    public static boolean isFilledMap(Material material) {
        return DefaultMaterials.getInstance().filledMap == material;
    }

    public static Collection<Material> getWater() {
        return DefaultMaterials.getInstance().water.getMaterials();
    }

    public static MaterialSet getWaterSet() {
        return DefaultMaterials.getInstance().water;
    }

    public static Collection<Material> getLava() {
        return DefaultMaterials.getInstance().lava.getMaterials();
    }

    public static Material blockToItem(Material block) {
        Material item = DefaultMaterials.getInstance().blockItems.get(block);
        return item == null ? block : item;
    }

    public static MaterialAndData getWallTorch() {
        return DefaultMaterials.getInstance().wallTorch;
    }

    public void setWallTorch(MaterialAndData wallTorch) {
        this.wallTorch = wallTorch;
    }

    public static MaterialAndData getRedstoneTorchOn() {
        return DefaultMaterials.getInstance().redstoneTorchOn;
    }

    public void setRedstoneTorchOn(MaterialAndData redstoneTorchOn) {
        this.redstoneTorchOn = redstoneTorchOn;
    }

    public static MaterialAndData getRedstoneTorchOff() {
        return DefaultMaterials.getInstance().redstoneTorchOff;
    }

    public void setRedstoneTorchOff(MaterialAndData redstoneTorchOff) {
        this.redstoneTorchOff = redstoneTorchOff;
    }

    public static MaterialAndData getRedstoneWallTorchOn() {
        return DefaultMaterials.getInstance().redstoneWallTorchOn;
    }

    public void setRedstoneWallTorchOn(MaterialAndData redstoneWallTorchOn) {
        this.redstoneWallTorchOn = redstoneWallTorchOn;
    }

    public static MaterialAndData getRedstoneWallTorchOff() {
        return DefaultMaterials.getInstance().redstoneWallTorchOff;
    }

    public void setRedstoneWallTorchOff(MaterialAndData redstoneWallTorchOff) {
        this.redstoneWallTorchOff = redstoneWallTorchOff;
    }

    public static boolean isAir(Material material) {
        return DefaultMaterials.getInstance().air.testMaterial(material);
    }

    public static boolean isBow(Material material) {
        return material == Material.BOW || material.name().equals("CROSSBOW");
    }
}

