/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.AbstractSchematic;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.schematic.LoadableSchematic;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class Schematic
extends AbstractSchematic
implements LoadableSchematic {
    public Schematic(MageController controller) {
        super(controller);
    }

    @Override
    public void load(short width, short height, short length, int[] blockTypes, byte[] data, Map<Integer, String> rawPallete, Collection<Object> tileEntityData, Collection<Object> entityData, Vector origin) {
        HashMap<Integer, MaterialAndData> palette = new HashMap<Integer, MaterialAndData>();
        for (Map.Entry<Integer, String> entry : rawPallete.entrySet()) {
            String blockData = entry.getValue();
            Material material = CompatibilityLib.getCompatibilityUtils().getMaterial(blockData);
            if (material == null) continue;
            palette.put(entry.getKey(), new MaterialAndData(material, blockData));
        }
        this.initialize((short)width, (short)height, (short)length);
        this.loadEntities(entityData, origin);
        this.loadTileEntities(tileEntityData);
        if (blockTypes != null) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    for (int x = 0; x < width; ++x) {
                        int index = x + (y * length + z) * width;
                        int palleteIndex = blockTypes[index];
                        MaterialAndData material = (MaterialAndData)palette.get(palleteIndex);
                        if (material == null) continue;
                        BlockVector blockLocation = new BlockVector(x, y, z);
                        this.blocks[x][y][z] = material = this.addTileEntity(blockLocation, material, true);
                    }
                }
            }
        }
        this.loaded = true;
    }

    @Override
    protected void loadTileEntities(Collection<Object> tileEntityData) {
        if (tileEntityData == null || tileEntityData.isEmpty()) {
            return;
        }
        this.tileEntities = new HashMap();
        for (Object tileEntity : tileEntityData) {
            try {
                BlockVector position = CompatibilityLib.getCompatibilityUtils().getBlockVector(tileEntity, "Pos");
                if (position == null) continue;
                this.tileEntities.put(position, tileEntity);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

