/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.crafting;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.crafting.MagicRecipe;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public abstract class MagicCookingRecipe
extends MagicRecipe {
    protected Recipe recipe;
    protected ItemData ingredient;
    protected String group;
    protected float experience;
    protected int cookingTime;

    protected MagicCookingRecipe(String key, MagicController controller) {
        super(key, controller);
    }

    @Override
    public ItemStack load(ConfigurationSection configuration) {
        ItemStack item = super.load(configuration);
        if (item == null) {
            return null;
        }
        this.cookingTime = configuration.getInt("cooking_time") / 50;
        this.experience = (float)configuration.getDouble("experience");
        String materialKey = configuration.getString("ingredient");
        this.ingredient = this.controller.getOrCreateItem(materialKey);
        if (this.ingredient == null) {
            this.controller.getLogger().warning("Could not create " + this.getType() + " recipe ingredient: " + materialKey);
            return null;
        }
        this.recipe = this.createRecipe(item);
        if (this.recipe != null && this.group != null && !this.group.isEmpty()) {
            CompatibilityLib.getCompatibilityUtils().setRecipeGroup(this.recipe, this.group);
        }
        return item;
    }

    protected abstract Recipe createRecipe(ItemStack var1);

    @Override
    public Recipe getRecipe() {
        return this.recipe;
    }
}

