/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.economy;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.economy.BaseMagicCurrency;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ItemCurrency
extends BaseMagicCurrency {
    private final ItemStack item;

    public ItemCurrency(MageController controller, ConfigurationSection configuration) {
        super(controller, "item", configuration);
        MaterialAndData material;
        String itemKey = configuration.getString("item");
        this.item = itemKey == null || itemKey.isEmpty() ? null : ((material = new MaterialAndData(configuration.getString("item"))).isValid() ? material.getItemStack(1) : null);
    }

    private ItemStack getItemStack(double amount) {
        this.item.setAmount(this.getRoundedAmount(amount));
        return this.item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public double getBalance(Mage mage, CasterProperties caster) {
        double balance = 0.0;
        Inventory inventory = mage.getInventory();
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !mage.getController().itemsAreEqual(this.item, item)) continue;
            balance += (double)item.getAmount();
        }
        return balance;
    }

    @Override
    public boolean has(Mage mage, CasterProperties caster, double amount) {
        return mage.hasItem(this.getItemStack(amount));
    }

    @Override
    public void deduct(Mage mage, CasterProperties caster, double amount) {
        mage.removeItem(this.getItemStack(amount));
    }

    @Override
    public boolean give(Mage mage, CasterProperties caster, double amount) {
        return mage.giveItem(this.getItemStack(amount).clone(), true, false);
    }

    @Override
    public String formatAmount(double amount, Messages messages) {
        int rounded = this.getRoundedAmount(amount);
        String amountString = this.formatter.format(rounded);
        String label = rounded == 1 ? this.singularName : this.name;
        return amountString + " " + label;
    }

    @Override
    public boolean isValid() {
        return this.item != null;
    }
}

