/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.MageContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.Location;

public class WandContext
extends MageContext {
    @Nullable
    protected Wand wand;

    public WandContext(@Nonnull Mage mage, @Nullable Wand wand) {
        super(mage);
        this.wand = wand;
    }

    @Override
    @Nullable
    public Wand getWand() {
        return this.wand;
    }

    @Override
    @Nullable
    public Wand checkWand() {
        boolean offhand = false;
        if (this.wand != null) {
            offhand = this.wand.isInOffhand();
            this.wand.deactivate();
        }
        this.wand = this.mage.checkWand();
        if (offhand) {
            this.wand = this.mage.getOffhandWand();
        }
        return this.wand;
    }

    @Override
    @Nullable
    public Location getCastLocation() {
        if (this.location != null || this.locationCleared) {
            return this.location;
        }
        Location wandLocation = this.wand == null ? null : this.wand.getLocation();
        return wandLocation == null ? this.getEyeLocation() : wandLocation;
    }

    @Override
    @Nullable
    public Color getEffectColor() {
        Color color = null;
        if (this.wand != null) {
            color = this.wand.getEffectColor();
        }
        if (color == null) {
            color = this.mage.getEffectColor();
        }
        return color;
    }

    @Override
    @Nullable
    public String getEffectParticle() {
        String particleName = null;
        if (this.wand != null) {
            particleName = this.wand.getEffectParticleName();
        }
        if (particleName == null) {
            particleName = this.mage.getEffectParticleName();
        }
        return particleName;
    }
}

