/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect.builtin;

import com.elmakers.mine.bukkit.effect.EffectRepeating;
import com.elmakers.mine.bukkit.slikey.effectlib.math.VectorTransform;
import com.elmakers.mine.bukkit.slikey.effectlib.util.DynamicLocation;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class EffectTransform
extends EffectRepeating {
    private VectorTransform positionTransform;
    private long playTime;
    private long lastIteration;
    private long totalSteps;
    private long steps;
    private long maxStep;

    @Override
    public void play() {
        this.playTime = 0L;
        this.totalSteps = 0L;
        this.lastIteration = System.currentTimeMillis();
        super.play();
    }

    @Override
    public void load(Plugin plugin, ConfigurationSection parameters) {
        super.load(plugin, parameters);
        ConfigurationSection transform = ConfigurationUtils.getConfigurationSection(parameters, "position_transform");
        this.positionTransform = transform != null ? new VectorTransform(transform) : null;
        this.steps = parameters.getInt("steps", 0);
        this.maxStep = parameters.getInt("max_steps", 0);
    }

    public void iterateSteps(Location originalOrigin, Location originalTarget) {
        int i = 0;
        while ((long)i < this.steps) {
            Location source = originalOrigin;
            Location target = originalTarget;
            if (this.playAtOrigin) {
                source = source.clone();
                source.add(this.positionTransform.get(source, this.totalSteps));
            }
            if (target != null && this.playAtTarget) {
                target = target.clone();
                target.add(this.positionTransform.get(target, this.totalSteps));
            }
            this.playEffect(new DynamicLocation(source, this.getOriginEntity()), new DynamicLocation(target, this.getTargetEntity()));
            ++this.totalSteps;
            if (this.maxStep > 0L && this.totalSteps >= this.maxStep) {
                this.totalSteps = 0L;
            }
            ++i;
        }
    }

    @Override
    public void iterate() {
        if (this.positionTransform == null) {
            this.playEffect();
            return;
        }
        Location origin = this.getOrigin();
        Location target = this.getTarget();
        if (origin == null) {
            return;
        }
        if (this.steps > 0L) {
            this.iterateSteps(origin, target);
            return;
        }
        Location source = origin;
        double t = (double)this.playTime / 1000.0;
        if (this.playAtOrigin) {
            source = source.clone();
            source.add(this.positionTransform.get(source, t));
        }
        if (target != null && this.playAtTarget) {
            target = target.clone();
            target.add(this.positionTransform.get(target, t));
        }
        long now = System.currentTimeMillis();
        this.playTime += now - this.lastIteration;
        this.lastIteration = now;
        this.playEffect(new DynamicLocation(source, this.getOriginEntity()), new DynamicLocation(target, this.getTargetEntity()));
    }
}

