/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.lang.ref.WeakReference;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.util.BlockVector;

public class SpawnedEntity {
    private final String worldName;
    private final BlockVector location;
    private final UUID id;
    private final WeakReference<Entity> entity;

    public SpawnedEntity(Entity entity) {
        this.entity = new WeakReference<Entity>(entity);
        this.worldName = entity.getWorld().getName();
        this.location = new BlockVector(entity.getLocation().toVector());
        this.id = entity.getUniqueId();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpawnedEntity)) {
            return false;
        }
        SpawnedEntity other = (SpawnedEntity)o;
        return other.id.equals(this.id);
    }

    @Nullable
    public Entity getEntity() {
        return (Entity)this.entity.get();
    }

    public void despawn(MageController controller, CastContext context) {
        Entity entity = this.getEntity();
        if (entity == null || !entity.isValid()) {
            World world = controller.getPlugin().getServer().getWorld(this.worldName);
            if (world == null) {
                return;
            }
            Location entityLocation = new Location(world, this.location.getX(), this.location.getY(), this.location.getZ());
            if (!CompatibilityLib.getCompatibilityUtils().isChunkLoaded(entityLocation)) {
                CompatibilityLib.getCompatibilityUtils().loadChunk(entityLocation, false, chunk -> {
                    Entity removeEntity = CompatibilityLib.getCompatibilityUtils().getEntity(world, this.id);
                    if (removeEntity != null) {
                        UndoList.setUndoList(removeEntity, null);
                        removeEntity.remove();
                    }
                });
            } else {
                entity = CompatibilityLib.getCompatibilityUtils().getEntity(world, this.id);
            }
        }
        if (entity != null && entity.isValid()) {
            if (context != null && context.hasEffects("undo_entity")) {
                context.playEffects("undo_entity", 1.0f, null, null, entity.getLocation(), entity, null);
            }
            UndoList.setUndoList(entity, null);
            entity.remove();
        }
    }
}

