/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.wand.Wand;
import fr.maxlego08.zauctionhouse.api.event.events.AuctionPreSellEvent;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class AuctionHouseManager
implements Listener {
    private final MageController controller;
    private boolean enabled;
    private boolean registered;

    public AuctionHouseManager(MageController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection configuration) {
        this.enabled = configuration.getBoolean("enabled", true);
        String statusString = !this.enabled ? " but is disabled in Magic's configs" : ", will prevent auctioning bound wands";
        if (!this.registered && this.enabled) {
            this.register();
        }
        this.controller.getLogger().info("zAuctionHouse found" + statusString);
    }

    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.controller.getPlugin());
        this.registered = true;
    }

    @EventHandler
    public void onSell(AuctionPreSellEvent event) {
        if (!this.enabled) {
            return;
        }
        ItemStack item = event.getItemStack();
        if (this.controller.isSkill(item)) {
            event.setCancelled(true);
            return;
        }
        Wand wand = this.controller.getIfWand(item);
        if (wand != null && wand.isBound()) {
            event.setCancelled(true);
        }
    }
}

