/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.archyx.aureliumskills.api.AureliumAPI;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.stats.Stats;
import com.elmakers.mine.bukkit.api.attributes.AttributeProvider;
import com.elmakers.mine.bukkit.api.event.EarnEvent;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.integration.AureliumSkillCurrency;
import com.elmakers.mine.bukkit.magic.ManaController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class AureliumSkillsManager
implements ManaController,
AttributeProvider,
Listener {
    private final MageController controller;
    private final Set<String> usesMana = new HashSet<String>();
    private final Map<Skills, Double> xpEarnRates = new HashMap<Skills, Double>();
    private boolean enabled;
    private boolean useAttributes;
    private double manaScale;
    private double manaCostReduction;
    private boolean registerCurrencies;

    public AureliumSkillsManager(MageController controller) {
        this.controller = controller;
        Plugin plugin = controller.getPlugin();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public void load(ConfigurationSection configuration) {
        Object statusString;
        this.enabled = configuration.getBoolean("enabled", true);
        this.useAttributes = this.enabled && configuration.getBoolean("use_attributes", true);
        this.manaScale = configuration.getDouble("mana_scale", 1.0);
        this.manaCostReduction = configuration.getDouble("mana_cost_reduction", 0.0);
        boolean bl = this.registerCurrencies = this.enabled && configuration.getBoolean("use_xp_currencies", true);
        if (this.manaScale <= 0.0) {
            this.controller.getLogger().info("Invalid mana scale in aurelium_skills configuration: " + this.manaScale);
            this.manaScale = 1.0;
        }
        boolean useMana = this.enabled && configuration.getBoolean("use_mana", true);
        this.usesMana.clear();
        if (useMana) {
            this.usesMana.addAll(ConfigurationUtils.getStringList(configuration, "mana_classes"));
        } else {
            this.manaCostReduction = 0.0;
        }
        useMana = !this.usesMana.isEmpty();
        this.xpEarnRates.clear();
        ConfigurationSection earnRates = configuration.getConfigurationSection("xp_earn_from_sp");
        for (String key : earnRates.getKeys(false)) {
            try {
                Skills skill = Skills.valueOf((String)key);
                this.xpEarnRates.put(skill, earnRates.getDouble(key));
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid AureliumSkills XP type in xp_earn_from_sp config: " + key);
            }
        }
        if (!(useMana || this.useAttributes || this.registerCurrencies)) {
            statusString = " but integration is disabled in configs";
        } else {
            statusString = ", will integrate for ";
            ArrayList<Object> integrations = new ArrayList<Object>();
            if (useMana) {
                integrations.add("mana for classes (" + StringUtils.join(this.usesMana, ",") + ")");
            }
            if (this.useAttributes) {
                integrations.add("skill/stat attributes");
            }
            if (this.registerCurrencies) {
                integrations.add("xp currencies");
            }
            statusString = (String)statusString + StringUtils.join(integrations, ",");
        }
        this.controller.getLogger().info("AureliumSkills found" + (String)statusString);
        if (!useMana) {
            this.controller.getLogger().info("  If you want Magic spells to use AureliumSkills mana, use &7/mconfig configure config aurelium_skills.use_mana true");
        }
    }

    public void register(ConfigurationSection currencyConfiguration) {
        if (this.registerCurrencies) {
            ArrayList<String> names = new ArrayList<String>();
            for (Skills skill : Skills.values()) {
                ConfigurationSection configuration = currencyConfiguration.getConfigurationSection(skill.name());
                if (configuration == null) {
                    configuration = ConfigurationUtils.newConfigurationSection();
                }
                this.controller.register(new AureliumSkillCurrency(this, skill, configuration));
                names.add(skill.name());
            }
            this.controller.getLogger().info("Registered AureliumSkills XP as currencies: " + StringUtils.join(names, ","));
        }
    }

    public double getManaCostReduction() {
        return this.manaCostReduction;
    }

    public boolean useMana(String mageClass) {
        return this.usesMana.contains(mageClass);
    }

    public boolean useAttributes() {
        return this.useAttributes;
    }

    @Override
    public double getMaxMana(Player player) {
        return (int)(this.manaScale * AureliumAPI.getMaxMana((Player)player));
    }

    @Override
    public double getManaRegen(Player player) {
        double regen = OptionL.getDouble((Option)Option.REGENERATION_BASE_MANA_REGEN) + AureliumAPI.getStatLevel((Player)player, (Stat)Stats.REGENERATION) * OptionL.getDouble((Option)Option.REGENERATION_MANA_MODIFIER);
        return this.manaScale * regen;
    }

    @Override
    public double getMana(Player player) {
        return (float)(this.manaScale * AureliumAPI.getMana((Player)player));
    }

    @Override
    public void removeMana(Player player, double amount) {
        AureliumAPI.setMana((Player)player, (double)(AureliumAPI.getMana((Player)player) - amount / this.manaScale));
    }

    @Override
    public void setMana(Player player, double amount) {
        AureliumAPI.setMana((Player)player, (double)(amount / this.manaScale));
    }

    @Override
    public Set<String> getAllAttributes() {
        HashSet<String> stats = new HashSet<String>();
        for (Stats stats2 : Stats.values()) {
            stats.add(stats2.name());
        }
        for (Stats stats3 : Skills.values()) {
            stats.add(stats3.name());
        }
        return stats;
    }

    @Override
    @Nullable
    public Double getAttributeValue(String attribute, Player player) {
        try {
            Stats stat = Stats.valueOf((String)attribute);
            return AureliumAPI.getStatLevel((Player)player, (Stat)stat);
        }
        catch (Exception stat) {
            try {
                Skills skill = Skills.valueOf((String)attribute);
                return AureliumAPI.getSkillLevel((Player)player, (Skill)skill);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public MageController getController() {
        return this.controller;
    }

    @EventHandler
    public void onEarn(EarnEvent event) {
        if (event.getEarnCause() != EarnEvent.EarnCause.SPELL_CAST) {
            return;
        }
        Mage mage = event.getMage();
        if (!mage.isPlayer()) {
            return;
        }
        for (Map.Entry<Skills, Double> xpEarnRate : this.xpEarnRates.entrySet()) {
            AureliumAPI.addXp((Player)mage.getPlayer(), (Skill)((Skill)xpEarnRate.getKey()), (double)(xpEarnRate.getValue() * event.getEarnAmount()));
        }
    }
}

