/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.elmakers.mine.bukkit.integration.NPCSupplier;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.entity.Entity;

public final class NPCSupplierSet
implements NPCSupplier {
    private final Set<NPCSupplier> suppliers = Sets.newIdentityHashSet();

    @Override
    public boolean isNPC(Entity entity) {
        for (NPCSupplier supplier : this.suppliers) {
            if (!supplier.isNPC(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStaticNPC(Entity entity) {
        for (NPCSupplier supplier : this.suppliers) {
            if (!supplier.isStaticNPC(entity)) continue;
            return true;
        }
        return false;
    }

    public void register(@Nonnull NPCSupplier supplier) {
        this.suppliers.add((NPCSupplier)Preconditions.checkNotNull((Object)supplier));
    }
}

