/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.integration.TokenManagerCurrency;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import me.realized.tokenmanager.api.TokenManager;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class TokenManagerController {
    private final TokenManager tokenManager;
    private final MageController controller;
    private boolean enabled;

    public TokenManagerController(MageController controller, Plugin tokenManagerPlugin) {
        this.controller = controller;
        this.tokenManager = tokenManagerPlugin instanceof TokenManager ? (TokenManager)tokenManagerPlugin : null;
    }

    public void load(ConfigurationSection configuration) {
        this.enabled = configuration.getBoolean("enabled", true);
        String statusString = !this.enabled ? " but is disabled in Magic's configs" : (this.tokenManager == null ? " but integration failed" : ", registering tokens currency");
        this.controller.getLogger().info("TokenManager found" + statusString);
    }

    public void register(ConfigurationSection currencyConfiguration) {
        if (this.enabled && this.tokenManager != null) {
            ConfigurationSection configuration = currencyConfiguration.getConfigurationSection("tokens");
            if (configuration == null) {
                configuration = ConfigurationUtils.newConfigurationSection();
            }
            this.controller.register(new TokenManagerCurrency(this.controller, this.tokenManager, configuration));
        }
    }
}

