/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Is On Path")
@Description(value={"Checks whether a player is on a progression path."})
@Examples(value={"player is on path \"architect\"", "player does not have path \"master\"", "player has finished path \"beginner\""})
public class CondHasPath
extends Condition {
    private Expression<Entity> entities;
    private Expression<String> paths;
    private boolean finished;
    private boolean exact;

    public static void register() {
        Skript.registerCondition(CondHasPath.class, (String[])new String[]{"%entities% (is|are) on path[s] %strings%", "%entities% has path[s] %strings%", "%entities% has finished path[s] %strings%", "%entities% (isn't|is not|aren't|are not) on path[s] %strings%", "%entities% (ha(s|ve) not|do[es]n't have) path[s] %strings%", "%entities% (ha(s|ve) not) finished path[s] %strings%"});
    }

    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = vars[0];
        this.paths = vars[1];
        this.setNegated(matchedPattern >= 3);
        this.exact = matchedPattern == 0 || matchedPattern == 3;
        this.finished = matchedPattern == 2 || matchedPattern == 5;
        return true;
    }

    private boolean checkPath(CasterProperties properties, String pathKey) {
        if (properties == null) {
            return false;
        }
        ProgressionPath path = properties.getPath();
        if (path == null) {
            return false;
        }
        if (this.finished) {
            if (path.hasPath(pathKey)) {
                if (path.getKey().equals(pathKey)) {
                    return !path.canProgress(properties);
                }
                return true;
            }
            return false;
        }
        if (this.exact) {
            return path.getKey().equalsIgnoreCase(pathKey);
        }
        return path.hasPath(pathKey);
    }

    public boolean check(final Event e) {
        return this.entities.check(e, (Checker)new Checker<Entity>(){

            public boolean check(Entity entity) {
                final Mage mage = MagicPlugin.getAPI().getController().getRegisteredMage(entity);
                if (mage == null) {
                    return false;
                }
                return CondHasPath.this.paths.check(e, (Checker)new Checker<String>(){

                    public boolean check(String pathKey) {
                        Wand wand = mage.getActiveWand();
                        if (CondHasPath.this.checkPath(wand, pathKey)) {
                            return true;
                        }
                        MageClass activeClass = mage.getActiveClass();
                        return CondHasPath.this.checkPath(activeClass, pathKey);
                    }
                }, CondHasPath.this.isNegated());
            }
        });
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.exact) {
            return this.entities.toString(e, debug) + (this.entities.isSingle() ? " is" : " are") + (this.isNegated() ? " not" : "") + " on path " + String.valueOf(this.paths);
        }
        return this.entities.toString(e, debug) + (this.entities.isSingle() ? " has" : " have") + (this.isNegated() ? " not" : "") + (this.finished ? " finished" : "") + " path " + String.valueOf(this.paths);
    }
}

