/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Spawn Magic Mob")
@Description(value={"Spawn a magic mob."})
@Examples(value={"spawn 3 \"warlock\" at the targeted block", "spawn a \"mutant\" 5 meters above the player"})
public class EffSpawn
extends Effect {
    private Expression<Location> locations;
    private Expression<String> mobKeys;
    private Expression<Number> amount;

    public static void register() {
        Skript.registerEffect(EffSpawn.class, (String[])new String[]{"spawn [a] %strings% [%directions% %locations%]", "spawn %number% of %strings% [%directions% %locations%]"});
    }

    protected void execute(Event event) {
        Number count = null;
        if (this.amount != null) {
            count = (Number)this.amount.getSingle(event);
        }
        if (count == null) {
            count = 1;
        }
        MageController controller = MagicPlugin.getAPI().getController();
        String[] keys = (String[])this.mobKeys.getArray(event);
        for (Location location : (Location[])this.locations.getArray(event)) {
            for (String mobKey : keys) {
                int i = 0;
                while ((double)i < count.doubleValue()) {
                    controller.spawnMob(mobKey, location);
                    ++i;
                }
            }
        }
    }

    public String toString(Event event, boolean debug) {
        return "spawn " + (String)(this.amount != null ? this.amount.toString(event, debug) + " " : "") + this.mobKeys.toString(event, debug) + " " + this.locations.toString(event, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.amount = matchedPattern == 0 ? null : exprs[0];
        this.mobKeys = exprs[matchedPattern];
        this.locations = Direction.combine(exprs[1 + matchedPattern], exprs[2 + matchedPattern]);
        return true;
    }
}

