/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.item;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public class Icon
implements com.elmakers.mine.bukkit.api.item.Icon {
    private final MageController controller;
    private final String itemKey;
    private final String itemDisabledKey;
    private final String legacyItemKey;
    private final String legacyItemDisabledKey;
    private final String vanillaItemKey;
    private final String vanillaItemDisabledKey;
    private final String url;
    private final String urlDisabled;
    private final String glyph;
    private final String type;
    private final boolean forceUrl;

    public Icon(MageController controller) {
        this.controller = controller;
        this.itemKey = BaseSpell.DEFAULT_SPELL_ICON.name().toLowerCase();
        this.itemDisabledKey = null;
        this.legacyItemKey = null;
        this.legacyItemDisabledKey = null;
        this.vanillaItemKey = null;
        this.vanillaItemDisabledKey = null;
        this.url = null;
        this.urlDisabled = BaseSpell.DEFAULT_DISABLED_ICON_URL;
        this.glyph = null;
        this.forceUrl = false;
        this.type = null;
    }

    public Icon(MageController controller, ConfigurationSection configuration) {
        this.controller = controller;
        this.itemKey = configuration.getString("item");
        this.itemDisabledKey = configuration.getString("item_disabled");
        this.legacyItemKey = configuration.getString("legacy_item");
        this.legacyItemDisabledKey = configuration.getString("legacy_item_disabled");
        this.vanillaItemKey = configuration.getString("vanilla_item");
        this.vanillaItemDisabledKey = configuration.getString("vanilla_item_disabled");
        this.url = configuration.getString("url");
        this.urlDisabled = configuration.getString("url_disabled");
        this.glyph = configuration.getString("glyph");
        this.forceUrl = configuration.getBoolean("force_url", false);
        this.type = configuration.getString("type");
    }

    public Icon(com.elmakers.mine.bukkit.api.item.Icon defaultAPI, com.elmakers.mine.bukkit.api.item.Icon baseAPI) {
        if (!(baseAPI instanceof Icon) || !(defaultAPI instanceof Icon)) {
            throw new IllegalStateException("Icon is not the correct implementation type");
        }
        Icon defaultIcon = (Icon)defaultAPI;
        Icon baseIcon = (Icon)baseAPI;
        this.controller = defaultIcon.controller;
        this.itemKey = baseIcon.itemKey != null ? baseIcon.itemKey : defaultIcon.itemKey;
        this.itemDisabledKey = baseIcon.itemDisabledKey != null ? baseIcon.itemDisabledKey : defaultIcon.itemDisabledKey;
        this.legacyItemKey = baseIcon.legacyItemKey != null ? baseIcon.legacyItemKey : defaultIcon.legacyItemKey;
        this.legacyItemDisabledKey = baseIcon.legacyItemDisabledKey != null ? baseIcon.legacyItemDisabledKey : defaultIcon.legacyItemDisabledKey;
        this.vanillaItemKey = baseIcon.vanillaItemKey != null ? baseIcon.vanillaItemKey : defaultIcon.vanillaItemKey;
        this.vanillaItemDisabledKey = baseIcon.vanillaItemDisabledKey != null ? baseIcon.vanillaItemDisabledKey : defaultIcon.vanillaItemDisabledKey;
        this.url = baseIcon.url != null ? baseIcon.url : defaultIcon.url;
        this.urlDisabled = baseIcon.urlDisabled != null ? baseIcon.urlDisabled : defaultIcon.urlDisabled;
        this.glyph = baseIcon.glyph != null ? baseIcon.glyph : defaultIcon.glyph;
        this.forceUrl = baseIcon.forceUrl;
        this.type = baseIcon.type;
    }

    public Icon(com.elmakers.mine.bukkit.api.item.Icon baseIcon, ConfigurationSection configuration, String itemIcon) {
        if (!(baseIcon instanceof Icon)) {
            throw new IllegalStateException("Icon is not the correct implementation type");
        }
        Icon other = (Icon)baseIcon;
        this.controller = other.controller;
        this.itemKey = configuration.getString("icon_item", itemIcon != null ? itemIcon : other.itemKey);
        this.itemDisabledKey = configuration.getString("icon_disabled", other.itemDisabledKey);
        this.legacyItemKey = configuration.getString("legacy_icon", other.legacyItemKey);
        this.legacyItemDisabledKey = configuration.getString("legacy_icon_disabled", other.legacyItemDisabledKey);
        this.vanillaItemKey = configuration.getString("vanilla_item", other.vanillaItemKey);
        this.vanillaItemDisabledKey = configuration.getString("vanilla_item_disabled", other.vanillaItemDisabledKey);
        this.url = configuration.getString("icon_url", other.url);
        this.urlDisabled = configuration.getString("icon_disabled_url", other.urlDisabled);
        this.glyph = configuration.getString("glyph", other.glyph);
        boolean onlyHasUrl = configuration.contains("icon_url") && itemIcon == null;
        this.forceUrl = configuration.getBoolean("force_url", onlyHasUrl);
        this.type = configuration.getString("type", other.type);
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public String getUrlDisabled() {
        return this.urlDisabled;
    }

    @Override
    @Nullable
    public String getGlyph() {
        return this.glyph;
    }

    @Override
    public boolean forceUrl() {
        return this.forceUrl;
    }

    private MaterialAndData getItem(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        ItemData itemData = this.controller.getOrCreateItem(key);
        return itemData == null ? null : itemData.getMaterialAndData();
    }

    @Override
    @Nullable
    public MaterialAndData getItemMaterial(MageController controller) {
        if ((this.forceUrl || controller.isUrlIconsEnabled()) && this.url != null) {
            return this.getItem("skull:" + this.url);
        }
        return this.getItemMaterial(controller.isLegacyIconsEnabled(), controller.isVanillaIconsEnabled());
    }

    @Override
    @Nullable
    @Deprecated
    public MaterialAndData getItemMaterial(boolean isLegacy) {
        return this.getItemMaterial(isLegacy, false);
    }

    @Nullable
    public MaterialAndData getItemMaterial(boolean isLegacy, boolean isVanilla) {
        String useKey = null;
        if (isLegacy) {
            useKey = this.legacyItemKey;
        }
        if (isVanilla && (useKey == null || useKey.isEmpty())) {
            useKey = this.vanillaItemKey;
        }
        if (useKey == null || useKey.isEmpty()) {
            useKey = this.itemKey;
        }
        return this.getItem(useKey);
    }

    @Override
    @Nullable
    public MaterialAndData getItemDisabledMaterial(MageController controller) {
        if (this.forceUrl || controller.isUrlIconsEnabled()) {
            if (this.urlDisabled != null) {
                return this.getItem("skull:" + this.urlDisabled);
            }
            if (this.url != null) {
                return this.getItem("skull:" + this.url);
            }
        }
        return this.getItemDisabledMaterial(controller.isLegacyIconsEnabled(), controller.isVanillaIconsEnabled());
    }

    @Override
    @Nullable
    @Deprecated
    public MaterialAndData getItemDisabledMaterial(boolean isLegacy) {
        return this.getItemDisabledMaterial(isLegacy, false);
    }

    @Nullable
    public MaterialAndData getItemDisabledMaterial(boolean isLegacy, boolean isVanilla) {
        String useKey = null;
        if (isLegacy) {
            String string = useKey = this.legacyItemDisabledKey != null && !this.legacyItemDisabledKey.isEmpty() ? this.legacyItemDisabledKey : this.legacyItemKey;
        }
        if (isVanilla && (useKey == null || useKey.isEmpty())) {
            String string = useKey = this.vanillaItemDisabledKey != null && !this.vanillaItemDisabledKey.isEmpty() ? this.vanillaItemDisabledKey : this.vanillaItemKey;
        }
        if (useKey == null || useKey.isEmpty()) {
            useKey = this.itemDisabledKey != null && !this.itemDisabledKey.isEmpty() ? this.itemDisabledKey : this.itemKey;
        }
        return this.getItem(useKey);
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }
}

