/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicProperties;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class BaseMagicProperties
implements MagicProperties {
    @Nonnull
    protected final MagicController controller;
    @Nonnull
    protected ConfigurationSection configuration = ConfigurationUtils.newConfigurationSection();
    public static final ImmutableSet<String> PROPERTY_KEYS = ImmutableSet.of((Object)"path", (Object)"template", (Object)"mana", (Object)"mana_regeneration", (Object)"mana_max", (Object)"mana_max_boost", (Object[])new String[]{"mana_regeneration_boost", "mana_per_damage", "reset_mana_on_activate", "consume_reduction", "cost_reduction", "cooldown_reduction", "hotbar_count", "max_spells", "icon", "overrides", "protection", "potion_effects", "brushes", "brush_inventory", "spells", "spell_inventory", "spell_levels", "powered", "protected", "earn_multiplier", "attributes", "tags", "ignored_by_mobs", "allow_container_copy", "ignore_particles", "reflect_chance", "reflect_fov", "allow_path_overrides", "block_fov", "block_chance", "block_reflect_chance", "block_mage_cooldown", "block_cooldown"});
    public static final ImmutableSet<String> HIDDEN_PROPERTY_KEYS = ImmutableSet.of((Object)"owner", (Object)"owner_id", (Object)"version", (Object)"item_attributes", (Object)"item_attribute_slot", (Object)"mana_timestamp", (Object[])new String[]{"storage", "hotbar", "template"});

    protected BaseMagicProperties(@Nonnull MageController controller) {
        this(controller, null);
    }

    protected BaseMagicProperties(@Nonnull MageController controller, ConfigurationSection configuration) {
        Preconditions.checkArgument((boolean)(controller instanceof MagicController));
        this.controller = (MagicController)controller;
        if (configuration != null) {
            this.configuration = ConfigurationUtils.cloneConfiguration(configuration);
        }
    }

    public void load(@Nullable ConfigurationSection configuration) {
        this.configuration = ConfigurationUtils.cloneConfiguration(configuration);
    }

    public boolean hasOwnProperty(String key) {
        return this.configuration.contains(key);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.hasOwnProperty(key);
    }

    @Nonnull
    public ConfigurationSection getPropertyConfiguration(String key) {
        return this.configuration;
    }

    @Override
    @Nullable
    public Object getProperty(String key) {
        return this.getPropertyConfiguration(key).get(key);
    }

    @Override
    @Nullable
    public <T> T getProperty(String key, Class<T> type) {
        Object value = this.getProperty(key);
        if (value == null || !type.isInstance(value)) {
            return null;
        }
        return type.cast(value);
    }

    @Override
    @Nonnull
    public <T> T getProperty(String key, T defaultValue) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
        Class<?> clazz = defaultValue.getClass();
        Object value = this.getProperty(key);
        if (value != null && clazz.isInstance(value)) {
            return (T)clazz.cast(value);
        }
        if (value != null && value instanceof Number && defaultValue instanceof Number) {
            if (defaultValue instanceof Double) {
                return (T)clazz.cast(NumberConversions.toDouble((Object)value));
            }
            if (defaultValue instanceof Integer) {
                return (T)clazz.cast(NumberConversions.toInt((Object)value));
            }
            if (defaultValue instanceof Byte) {
                return (T)clazz.cast(NumberConversions.toByte((Object)value));
            }
            if (defaultValue instanceof Float) {
                return (T)clazz.cast(Float.valueOf(NumberConversions.toFloat((Object)value)));
            }
            if (defaultValue instanceof Long) {
                return (T)clazz.cast(NumberConversions.toLong((Object)value));
            }
            if (defaultValue instanceof Short) {
                return (T)clazz.cast(NumberConversions.toShort((Object)value));
            }
        }
        return defaultValue;
    }

    @Nullable
    public Object getObject(String key, Object defaultValue) {
        Object value = this.getProperty(key);
        return value == null ? defaultValue : value;
    }

    @Nullable
    public Object getObject(String key) {
        return this.getProperty(key);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.getPropertyConfiguration(key).getDouble(key, defaultValue);
    }

    @Override
    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return (float)this.getPropertyConfiguration(key).getDouble(key, (double)defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.getPropertyConfiguration(key).getInt(key, defaultValue);
    }

    @Override
    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.getPropertyConfiguration(key).getLong(key, defaultValue);
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getPropertyConfiguration(key).getBoolean(key, defaultValue);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean isBoolean(String key) {
        return this.getPropertyConfiguration(key).isBoolean(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        Object value = this.getProperty(key);
        return value == null ? defaultValue : value.toString();
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    @Nullable
    public List<String> getStringList(String key) {
        Object value = this.getProperty(key);
        return ConfigurationUtils.getStringList(value);
    }

    @Override
    @Nullable
    public List<ConfigurationSection> getSectionList(String key) {
        return ConfigurationUtils.getNodeList(this.getPropertyConfiguration(key), key);
    }

    @Nullable
    public String getIconDisabledKey() {
        return this.getIconKey("icon_disabled");
    }

    @Nullable
    public String getIconKey() {
        return this.getIconKey("icon");
    }

    @Nullable
    public String getIconKey(String iconKey) {
        if (this.controller.isLegacyIconsEnabled()) {
            return this.getString("legacy_" + iconKey, this.getString(iconKey));
        }
        if (this.controller.isVanillaIconsEnabled()) {
            return this.getString("vanilla_" + iconKey, this.getString(iconKey));
        }
        return this.getString(iconKey);
    }

    public boolean hasIconKey() {
        return this.hasIconKey("icon");
    }

    public boolean hasIconKey(String iconKey) {
        if (this.controller.isLegacyIconsEnabled()) {
            return this.hasProperty("legacy_" + iconKey) || this.hasProperty(iconKey);
        }
        if (this.controller.isVanillaIconsEnabled()) {
            return this.hasProperty("vanilla_" + iconKey) || this.hasProperty(iconKey);
        }
        return this.hasProperty(iconKey);
    }

    @Nullable
    public ConfigurationSection getConfigurationSection(String key) {
        Object value = this.getProperty(key);
        return value == null || !(value instanceof ConfigurationSection) ? null : (ConfigurationSection)value;
    }

    @Nullable
    public Vector getVector(String key, Vector def) {
        String stringData = this.getString(key, null);
        if (stringData == null) {
            return def;
        }
        return ConfigurationUtils.toVector(stringData);
    }

    @Nullable
    public Vector getVector(String key) {
        return this.getVector(key, null);
    }

    @Nonnull
    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    @Nullable
    protected static String getPotionEffectString(Map<PotionEffectType, Integer> potionEffects) {
        if (potionEffects.size() == 0) {
            return null;
        }
        ArrayList<String> effectStrings = new ArrayList<String>();
        for (Map.Entry<PotionEffectType, Integer> entry : potionEffects.entrySet()) {
            Object effectString = entry.getKey().getName();
            if (entry.getValue() > 0) {
                effectString = (String)effectString + ":" + String.valueOf(entry.getValue());
            }
            effectStrings.add((String)effectString);
        }
        return StringUtils.join(effectStrings, ",");
    }

    protected String describePotionEffect(PotionEffectType effect, int level) {
        Object effectName = effect.getName();
        String effectFirst = ((String)effectName).substring(0, 1);
        effectName = ((String)effectName).substring(1).toLowerCase().replace("_", " ");
        effectName = effectFirst + (String)effectName;
        effectName = this.controller.getMessages().get("potion_effects." + effect.getName().toLowerCase(), (String)effectName);
        return this.controller.getMessages().getLevelString("wand.potion_effect", level + 1, 5.0f).replace("$effect", (CharSequence)effectName);
    }

    protected void sendDebug(String debugMessage) {
    }

    protected void sendMessage(String messageKey) {
    }

    protected void sendAddMessage(String messageKey, String nameParam) {
        String message = this.getMessage(messageKey).replace("$name", nameParam);
        this.sendMessage(message);
    }

    protected String getMessage(String messageKey) {
        return this.getMessage(messageKey, "");
    }

    public String getMessage(String messageKey, String defaultValue) {
        return this.parameterizeMessage(this.controller.getMessages().get(this.getMessageKey(messageKey), defaultValue));
    }

    public String getMessageKey(String messageKey) {
        return messageKey;
    }

    protected String parameterizeMessage(String message) {
        return message;
    }

    public static String describeProperty(Object property) {
        return CompatibilityLib.getInventoryUtils().describeProperty(property, CompatibilityConstants.MAX_PROPERTY_DISPLAY_LENGTH);
    }

    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties, @Nullable Set<String> overriddenProperties) {
        ConfigurationSection itemConfig = this.getConfiguration();
        Set keys = itemConfig.getKeys(false);
        for (String key : keys) {
            Object value = itemConfig.get(key);
            if (value == null || ignoreProperties != null && ignoreProperties.contains(key)) continue;
            ChatColor propertyColor = ChatColor.GRAY;
            if (overriddenProperties == null || !overriddenProperties.contains(key)) {
                propertyColor = this.getAllPropertyKeys().contains(key) ? ChatColor.DARK_AQUA : ChatColor.DARK_GREEN;
            }
            sender.sendMessage(propertyColor.toString() + key + String.valueOf(ChatColor.GRAY) + ": " + String.valueOf(ChatColor.WHITE) + BaseMagicProperties.describeProperty(value));
        }
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties) {
        this.describe(sender, ignoreProperties, null);
    }

    @Override
    public void describe(CommandSender sender) {
        this.describe(sender, null);
    }

    protected void clearProperty(String key) {
        this.configuration.set(key, null);
    }

    @Override
    public boolean isEmpty() {
        return this.configuration.getKeys(false).isEmpty();
    }

    protected Set<String> getAllPropertyKeys() {
        return PROPERTY_KEYS;
    }
}

