/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.configuration.MageParameters;
import com.elmakers.mine.bukkit.magic.BaseMageModifier;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.magic.TemplateProperties;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class MageClass
extends BaseMageModifier
implements com.elmakers.mine.bukkit.api.magic.MageClass {
    public static final ImmutableSet<String> PROPERTY_KEYS = new ImmutableSet.Builder().addAll(BaseMageModifier.PROPERTY_KEYS).add((Object[])new String[]{"class_items", "discover_recipes"}).build();

    public MageClass(@Nonnull Mage mage, @Nonnull MageClassTemplate template) {
        super(mage, template.hasParent() ? MagicPropertyType.SUBCLASS : MagicPropertyType.CLASS, (TemplateProperties)template);
        this.setTemplate(template);
    }

    @Override
    public String getMessageKey(String key) {
        TemplateProperties template = this.getTemplate();
        if (template != null) {
            String mageKey = "classes." + template.getKey() + "." + key;
            if (this.controller.getMessages().containsKey(mageKey)) {
                return mageKey;
            }
        }
        return "mage." + key;
    }

    public void onRemoved() {
        this.onLocked();
        this.trigger("removed");
    }

    @Override
    public void onLocked() {
        Player player;
        this.deactivate();
        if (this.getBoolean("clean_on_lock", false) && (player = this.mage.getPlayer()) != null) {
            PlayerInventory inventory = player.getInventory();
            String key = this.getKey();
            for (int i = 0; i < inventory.getSize(); ++i) {
                String skillClass;
                ItemStack item = inventory.getItem(i);
                if (!this.controller.isSkill(item) || (skillClass = Wand.getSpellClass(item)) == null || !skillClass.equals(key)) continue;
                inventory.setItem(i, null);
            }
        }
        this.takeItems();
        this.cancelTrigger("unlock");
        this.trigger("lock");
    }

    @Override
    public void onUnlocked() {
        this.activate();
        this.discoverRecipes("discover_recipes");
        this.giveItems("class_items");
        this.trigger("unlock");
    }

    public void setTemplate(@Nonnull MageClassTemplate template) {
        super.setTemplate(template.getMageTemplate(this.getMage()));
    }

    @Override
    public void load(@Nullable ConfigurationSection configuration) {
        this.configuration = new MageParameters(this.getMage(), "Mage class " + this.getKey());
        if (configuration != null) {
            ConfigurationUtils.addConfigurations(this.configuration, configuration);
        }
        this.loadProperties();
    }

    @Override
    @Deprecated
    @Nullable
    public SpellTemplate getBaseSpell(String spellKey) {
        return this.getSpellTemplate(spellKey);
    }

    @Override
    protected Set<String> getAllPropertyKeys() {
        return PROPERTY_KEYS;
    }
}

