/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public abstract class Paginator<T> {
    private int rowsPerPage = 8;

    @Nullable
    protected abstract List<T> getList(CommandSender var1);

    @Nonnull
    protected abstract String describe(T var1);

    @Nonnull
    protected abstract String getTypeNamePlural();

    protected void showItems(CommandSender sender, List<T> items, int start, int end) {
        for (int i = start; i < end; ++i) {
            sender.sendMessage(this.describe(items.get(i)));
        }
    }

    public void list(CommandSender sender, String[] args) {
        List<T> sorted;
        int page = 0;
        String pageNumber = "?";
        if (args.length > 0) {
            try {
                pageNumber = args[0];
                page = Integer.parseInt(args[0]) - 1;
            }
            catch (Exception ex) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid page number: " + String.valueOf(ChatColor.WHITE) + args[0]);
                return;
            }
        }
        if ((sorted = this.getList(sender)) == null || sorted.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No " + this.getTypeNamePlural() + " to list");
            return;
        }
        int start = page * this.rowsPerPage;
        int end = start + this.rowsPerPage;
        int pages = (int)Math.ceil((double)sorted.size() / (double)this.rowsPerPage);
        end = Math.min(end, sorted.size());
        if (start < 0 || start >= sorted.size()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid page number: " + String.valueOf(ChatColor.WHITE) + pageNumber + String.valueOf(ChatColor.GRAY) + "/" + String.valueOf(ChatColor.GOLD) + pages);
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Total " + this.getTypeNamePlural() + ": " + String.valueOf(ChatColor.DARK_AQUA) + sorted.size());
        this.showItems(sender, sorted, start, end);
        if (sorted.size() > this.rowsPerPage) {
            sender.sendMessage("  " + String.valueOf(ChatColor.GRAY) + "Page " + String.valueOf(ChatColor.YELLOW) + (page + 1) + String.valueOf(ChatColor.GRAY) + "/" + String.valueOf(ChatColor.GOLD) + pages);
        }
    }
}

