/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command.config;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.config.AsyncProcessor;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.command.CommandSender;

public abstract class HttpPost
extends AsyncProcessor
implements Runnable {
    private final String requestBody;
    private final String url;
    protected final MagicController controller;
    protected final CommandSender sender;
    protected final Gson gson;

    public HttpPost(MagicController controller, Gson gson, CommandSender sender, String requestBody, String url) {
        this.controller = controller;
        this.gson = gson;
        this.sender = sender;
        this.requestBody = requestBody;
        this.url = url;
    }

    @Override
    public void run() {
        try {
            String line;
            URL url = new URL(this.url);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(this.requestBody.getBytes("UTF-8"));
            outputStream.close();
            BufferedReader responseInput = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            Object response = "";
            while ((line = responseInput.readLine()) != null) {
                response = (String)response + line;
            }
            this.processResponse((String)response);
        }
        catch (Exception ex) {
            this.fail(this.controller.getMessages().get("commands.mconfig.editor.error"), "Error processing HTTP request to " + this.url, ex);
            return;
        }
    }

    protected abstract void processResponse(String var1);

    protected void success(String message) {
        HttpPost.success(this.controller, this.sender, message);
    }

    protected void fail(String message) {
        HttpPost.fail(this.controller, this.sender, message);
    }

    protected void fail(String message, String errorMessage, Exception ex) {
        HttpPost.fail(this.controller, this.sender, message, errorMessage, ex);
    }
}

