/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.wand.Wand;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class AnvilController
implements Listener {
    private final MagicController controller;
    private boolean bindingEnabled = false;
    private boolean combiningEnabled = false;
    private boolean wandBookCombiningEnabled = true;
    private boolean bookCombiningDisabled = false;
    private boolean organizingEnabled = false;
    private boolean clearDescriptionOnRename = false;
    private boolean enableWandRenaming = true;
    private boolean enableSpellRenaming = false;
    private boolean disableAnvil = false;

    public AnvilController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection properties) {
        this.disableAnvil = properties.getBoolean("disable_anvil", false);
        this.bookCombiningDisabled = properties.getBoolean("disable_book_combining", this.bookCombiningDisabled);
        this.enableWandRenaming = properties.getBoolean("enable_wand_renaming", true);
        this.enableSpellRenaming = properties.getBoolean("enable_spell_renaming", false);
        this.bindingEnabled = properties.getBoolean("enable_anvil_binding", this.bindingEnabled);
        this.combiningEnabled = properties.getBoolean("enable_combining", this.combiningEnabled);
        this.wandBookCombiningEnabled = properties.getBoolean("enable_wand_book_combining", this.wandBookCombiningEnabled);
        this.organizingEnabled = properties.getBoolean("enable_organizing", this.organizingEnabled);
        this.clearDescriptionOnRename = properties.getBoolean("anvil_rename_clears_description", this.clearDescriptionOnRename);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getInventory().getType() != InventoryType.ANVIL) {
            return;
        }
        if (!event.getInventorySlots().contains(0)) {
            return;
        }
        ItemStack oldCursor = event.getOldCursor();
        ItemStack itemStack = oldCursor = oldCursor.hasItemMeta() ? CompatibilityLib.getItemUtils().makeReal(oldCursor) : oldCursor;
        if (Wand.isWand(oldCursor)) {
            ItemStack item = (ItemStack)event.getNewItems().get(0);
            if (item != null && item.hasItemMeta() && Wand.isWand(item = CompatibilityLib.getItemUtils().makeReal(item))) {
                Wand wand = this.controller.getWand(item);
                wand.updateName(false, false);
                final Inventory inventory = event.getInventory();
                final ItemStack finalItem = item;
                Bukkit.getScheduler().runTaskLater(this.controller.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        ItemStack item = inventory.getItem(0);
                        if (item != null && item.hasItemMeta()) {
                            inventory.setItem(0, finalItem);
                        }
                    }
                }, 1L);
            }
        } else if (Wand.isSpecial(oldCursor) && !this.enableSpellRenaming) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (this.disableAnvil && event.getInventory().getType().equals((Object)InventoryType.ANVIL)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        InventoryType inventoryType = event.getInventory().getType();
        InventoryType.SlotType slotType = event.getSlotType();
        Player player = (Player)event.getWhoClicked();
        Mage mage = this.controller.getMage(player);
        if (inventoryType == InventoryType.ANVIL) {
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            Inventory anvilInventory = event.getInventory();
            InventoryAction action = event.getAction();
            ItemStack firstItem = anvilInventory.getItem(0);
            ItemStack secondItem = anvilInventory.getItem(1);
            mage.sendDebugMessage(String.valueOf(ChatColor.AQUA) + "ANVIL CLICK: " + String.valueOf(ChatColor.WHITE) + "cursor wand? " + String.valueOf(ChatColor.GOLD) + Wand.isWand(cursor) + String.valueOf(ChatColor.WHITE) + " current wand?" + String.valueOf(ChatColor.GOLD) + Wand.isWand(current) + String.valueOf(ChatColor.WHITE) + " action: " + String.valueOf(ChatColor.GOLD) + String.valueOf(action) + String.valueOf(ChatColor.WHITE) + " slot: " + String.valueOf(ChatColor.GOLD) + String.valueOf(slotType) + String.valueOf(ChatColor.WHITE) + " first: " + String.valueOf(ChatColor.YELLOW) + (firstItem == null ? "null" : firstItem.getType().name()) + String.valueOf(ChatColor.WHITE) + ", second: " + String.valueOf(ChatColor.YELLOW) + (secondItem == null ? "null" : secondItem.getType().name()), 80);
            if (action == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                if (!Wand.isWand(current)) {
                    if (Wand.isSpecial(current) && !this.enableSpellRenaming && slotType != InventoryType.SlotType.RESULT && slotType != InventoryType.SlotType.CRAFTING) {
                        event.setCancelled(true);
                    }
                    return;
                }
                if (slotType == InventoryType.SlotType.CRAFTING) {
                    Wand wand = this.controller.getWand(current);
                    wand.updateName(true);
                    return;
                }
                if (slotType != InventoryType.SlotType.RESULT) {
                    Wand wand = this.controller.getWand(current);
                    wand.updateName(false, true);
                    return;
                }
            }
            if (slotType == InventoryType.SlotType.CRAFTING) {
                Wand wand;
                if (Wand.isWand(cursor)) {
                    wand = this.controller.getWand(cursor);
                    wand.updateName(false, true);
                } else if (Wand.isSpecial(cursor) && !this.enableSpellRenaming) {
                    event.setCancelled(true);
                    return;
                }
                if (Wand.isWand(current)) {
                    wand = this.controller.getWand(current);
                    if (this.clearDescriptionOnRename) {
                        wand.setDescription("");
                    }
                    wand.updateName(true);
                    if (event.getWhoClicked() instanceof Player && this.bindingEnabled) {
                        wand.tryToOwn((Player)event.getWhoClicked());
                    }
                }
                return;
            }
            if (slotType == InventoryType.SlotType.RESULT && Wand.isWand(current)) {
                ItemMeta secondMeta;
                if (!this.combiningEnabled && !this.wandBookCombiningEnabled && firstItem != null && secondItem != null) {
                    event.setCancelled(true);
                    return;
                }
                ItemMeta meta = current.getItemMeta();
                String newName = meta.getDisplayName();
                Wand wand = this.controller.getWand(current);
                wand.updateItem();
                if (!wand.canUse(player)) {
                    event.setCancelled(true);
                    mage.sendMessage(this.controller.getMessages().get("wand.bound").replace("$name", wand.getOwner()));
                    return;
                }
                boolean combinedWandAndBook = false;
                if (this.wandBookCombiningEnabled && secondItem != null && (secondMeta = secondItem.getItemMeta()) != null && secondMeta instanceof EnchantmentStorageMeta) {
                    if (!wand.isEnchantable()) {
                        event.setCancelled(true);
                        return;
                    }
                    EnchantmentStorageMeta enchantmentStorage = (EnchantmentStorageMeta)secondMeta;
                    if (!wand.addEnchantments(enchantmentStorage.getStoredEnchants())) {
                        event.setCancelled(true);
                        return;
                    }
                    combinedWandAndBook = true;
                }
                if (!combinedWandAndBook && this.bookCombiningDisabled && secondItem != null && (secondMeta = secondItem.getItemMeta()) != null && secondMeta instanceof EnchantmentStorageMeta) {
                    event.setCancelled(true);
                    return;
                }
                if (this.enableWandRenaming && wand.getBoolean("renamable", true)) {
                    wand.setName(newName);
                }
                if (this.organizingEnabled) {
                    wand.organizeInventory(this.controller.getMage(player));
                }
                if (this.bindingEnabled) {
                    wand.tryToOwn(player);
                }
                wand.saveState();
                return;
            }
            if (slotType == InventoryType.SlotType.RESULT && Wand.isSpecial(current) && !this.enableSpellRenaming) {
                event.setCancelled(true);
                return;
            }
            if (this.combiningEnabled && slotType == InventoryType.SlotType.RESULT) {
                if (Wand.isWand(firstItem) && Wand.isWand(secondItem)) {
                    Wand firstWand = this.controller.getWand(firstItem);
                    Wand secondWand = this.controller.getWand(secondItem);
                    if (!firstWand.isModifiable() || !secondWand.isModifiable()) {
                        mage.sendMessage("One of your wands can not be combined");
                        return;
                    }
                    if (!firstWand.canUse(player) || !secondWand.canUse(player)) {
                        mage.sendMessage("One of those wands is not bound to you");
                        return;
                    }
                    if (!firstWand.add(secondWand)) {
                        mage.sendMessage("These wands can not be combined with each other");
                        return;
                    }
                    anvilInventory.setItem(0, null);
                    anvilInventory.setItem(1, null);
                    cursor.setType(Material.AIR);
                    if (this.organizingEnabled) {
                        firstWand.organizeInventory(mage);
                    }
                    if (this.bindingEnabled) {
                        firstWand.tryToOwn(player);
                    }
                    player.getInventory().addItem(new ItemStack[]{firstWand.getItem()});
                    mage.sendMessage("Your wands have been combined!");
                } else if (this.organizingEnabled && Wand.isWand(firstItem)) {
                    Wand firstWand = this.controller.getWand(firstItem);
                    anvilInventory.setItem(0, null);
                    anvilInventory.setItem(1, null);
                    cursor.setType(Material.AIR);
                    firstWand.organizeInventory(mage);
                    if (this.bindingEnabled) {
                        firstWand.tryToOwn(player);
                    }
                    player.getInventory().addItem(new ItemStack[]{firstWand.getItem()});
                    mage.sendMessage("Your wand has been organized!");
                }
                return;
            }
        }
    }

    public boolean isCombiningEnabled() {
        return this.combiningEnabled;
    }

    public boolean isOrganizingEnabled() {
        return this.organizingEnabled;
    }
}

