/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.maps;

import com.elmakers.mine.bukkit.utility.ColorHD;
import java.awt.Color;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BufferedMapCanvas
implements MapCanvas {
    public static int CANVAS_WIDTH = 128;
    public static int CANVAS_HEIGHT = 128;
    private static MapCursorCollection emptyCursors = new MapCursorCollection();
    private Color[] pixels = new Color[16384];
    private Map<Color, DyeColor> dyeColors = new HashMap<Color, DyeColor>();

    @javax.annotation.Nullable
    public MapView getMapView() {
        return null;
    }

    public MapCursorCollection getCursors() {
        return emptyCursors;
    }

    public void setCursors(MapCursorCollection cursors) {
    }

    public void setPixelColor(int x, int y, @Nullable Color color) {
        if (x < 0 || y < 0 || x > CANVAS_WIDTH || y > CANVAS_HEIGHT) {
            return;
        }
        this.pixels[x + y * BufferedMapCanvas.CANVAS_WIDTH] = color;
        if (color.getAlpha() != 0 && !this.dyeColors.containsKey(color)) {
            org.bukkit.Color targetColor = org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
            DyeColor bestDyeColor = null;
            Double bestDistance = null;
            for (DyeColor testDyeColor : DyeColor.values()) {
                org.bukkit.Color testColor = testDyeColor.getColor();
                double testDistance = ColorHD.getDistance(testColor, targetColor);
                if (bestDistance != null && !(testDistance < bestDistance)) continue;
                bestDistance = testDistance;
                bestDyeColor = testDyeColor;
                if (testDistance == 0.0) break;
            }
            this.dyeColors.put(color, bestDyeColor);
        }
    }

    @Nullable
    public Color getPixelColor(int x, int y) {
        if (x < 0 || y < 0 || x > CANVAS_WIDTH || y > CANVAS_HEIGHT) {
            return null;
        }
        return this.pixels[x + y * CANVAS_WIDTH];
    }

    @NotNull
    public Color getBasePixelColor(int i, int i1) {
        return null;
    }

    public void setPixel(int x, int y, byte color) {
    }

    public byte getPixel(int x, int y) {
        return 0;
    }

    @javax.annotation.Nullable
    public DyeColor getDyeColor(int x, int y) {
        Color color = this.getPixelColor(x, y);
        if (color.getAlpha() == 0) {
            return null;
        }
        if (!this.dyeColors.containsKey(color)) {
            return null;
        }
        return this.dyeColors.get(color);
    }

    public byte getBasePixel(int x, int y) {
        return 0;
    }

    public void drawImage(int x, int y, Image image) {
        byte[] bytes = MapPalette.imageToBytes((Image)image);
        for (int x2 = 0; x2 < image.getWidth(null); ++x2) {
            for (int y2 = 0; y2 < image.getHeight(null); ++y2) {
                this.setPixel(x + x2, y + y2, bytes[y2 * image.getWidth(null) + x2]);
            }
        }
    }

    public void drawText(int x, int y, MapFont font, String text) {
        int xStart = x;
        byte color = 44;
        if (!font.isValid(text)) {
            throw new IllegalArgumentException("text contains invalid characters");
        }
        for (int i = 0; i < text.length(); ++i) {
            int j;
            char ch = text.charAt(i);
            if (ch == '\n') {
                x = xStart;
                y += font.getHeight() + 1;
                continue;
            }
            if (ch == '\u00a7' && (j = text.indexOf(59, i)) >= 0) {
                try {
                    color = Byte.parseByte(text.substring(i + 1, j));
                    i = j;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            MapFont.CharacterSprite sprite = font.getChar(text.charAt(i));
            for (int r = 0; r < font.getHeight(); ++r) {
                for (int c = 0; c < sprite.getWidth(); ++c) {
                    if (!sprite.get(r, c)) continue;
                    this.setPixel(x + c, y + r, color);
                }
            }
            x += sprite.getWidth() + 1;
        }
    }
}

