/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.materials;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.materials.EmptyMaterialSet;
import com.elmakers.mine.bukkit.materials.Union;
import com.elmakers.mine.bukkit.materials.WildcardMaterialSet;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;

public class MaterialSets {
    @Nullable
    public static Set<Material> toLegacy(@Nullable MaterialSet v) {
        return v == null ? null : MaterialSets.toLegacyNN(v);
    }

    @Nonnull
    public static Set<Material> toLegacyNN(@Nonnull MaterialSet v) {
        return ImmutableSet.copyOf(v.getMaterials());
    }

    public static MaterialSet wildcard() {
        return WildcardMaterialSet.INSTANCE;
    }

    public static MaterialSet empty() {
        return EmptyMaterialSet.INSTANCE;
    }

    public static MaterialSet union(MaterialSet left, MaterialSet right) {
        if (left == MaterialSets.empty()) {
            return right;
        }
        if (right == MaterialSets.empty()) {
            return left;
        }
        return MaterialSets.unionBuilder().add(left).add(right).build();
    }

    public static MaterialSet union(MaterialSet left, MaterialAndData right) {
        return MaterialSets.unionBuilder().add(left).add(right).build();
    }

    public static MaterialSet union(MaterialSet left, Material ... materials) {
        return MaterialSets.unionBuilder().add(left).addAll(materials).build();
    }

    public static Union unionBuilder() {
        return new Union();
    }
}

