/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.materials;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.materials.EmptyMaterialSet;
import com.elmakers.mine.bukkit.materials.MaterialSets;
import com.elmakers.mine.bukkit.materials.SimpleMaterialSet;
import com.elmakers.mine.bukkit.materials.WildcardMaterialSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;

public final class Union {
    private boolean wildcard = false;
    private final List<MaterialSet> sets = new ArrayList<MaterialSet>();
    private final List<MaterialAndData> materialAndDatas = new ArrayList<MaterialAndData>();
    private final Set<Material> materials = new HashSet<Material>();

    Union() {
    }

    public Union add(MaterialSet set) {
        Preconditions.checkNotNull((Object)set, (Object)"set");
        if (set instanceof EmptyMaterialSet) {
            return this;
        }
        if (set instanceof WildcardMaterialSet) {
            this.wildcard = true;
            return this;
        }
        if (set instanceof SimpleMaterialSet) {
            SimpleMaterialSet simpleSet = (SimpleMaterialSet)set;
            this.sets.addAll((Collection<MaterialSet>)simpleSet.parents);
            this.materialAndDatas.addAll((Collection<MaterialAndData>)simpleSet.materialAndDatas);
            this.materials.addAll((Collection<Material>)simpleSet.materials);
        } else {
            this.sets.add(set);
        }
        return this;
    }

    public Union add(Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"material");
        this.materials.add(material);
        return this;
    }

    public Union add(MaterialAndData materialAndData) {
        Preconditions.checkNotNull((Object)materialAndData, (Object)"materialAndData");
        Preconditions.checkArgument((boolean)materialAndData.isValid(), (String)"Material data is not valid: %s", (Object)materialAndData);
        this.materialAndDatas.add(materialAndData);
        return this;
    }

    public Union addAll(Material ... materials) {
        for (Material material : materials) {
            Preconditions.checkNotNull((Object)material, (Object)"material");
            this.materials.add(material);
        }
        return this;
    }

    public MaterialSet build() {
        ImmutableList newMaterialAndDatas;
        ImmutableSet newMaterials;
        if (this.wildcard) {
            return MaterialSets.wildcard();
        }
        boolean needMaterialList = !this.materials.isEmpty();
        for (MaterialSet set : this.sets) {
            needMaterialList |= !set.getMaterials().isEmpty();
        }
        if (!needMaterialList && this.sets.isEmpty() && this.materialAndDatas.isEmpty()) {
            return MaterialSets.empty();
        }
        if (needMaterialList) {
            ImmutableSet.Builder materialsBuilder = ImmutableSet.builder();
            materialsBuilder.addAll(this.materials);
            for (MaterialSet set : this.sets) {
                materialsBuilder.addAll(set.getMaterials());
            }
            newMaterials = materialsBuilder.build();
        } else {
            newMaterials = ImmutableSet.of();
        }
        if (!this.materialAndDatas.isEmpty()) {
            ImmutableList.Builder materialsBuilder = ImmutableList.builder();
            for (MaterialAndData materialAndData : this.materialAndDatas) {
                if (newMaterials.contains((Object)materialAndData.getMaterial())) continue;
                materialsBuilder.add((Object)materialAndData);
            }
            newMaterialAndDatas = materialsBuilder.build();
        } else {
            newMaterialAndDatas = ImmutableList.of();
        }
        return new SimpleMaterialSet((ImmutableList<MaterialSet>)ImmutableList.copyOf(this.sets), (ImmutableSet<Material>)newMaterials, (ImmutableList<MaterialAndData>)newMaterialAndDatas);
    }
}

