/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NCPAPI
implements Runnable {
    private Map<UUID, Long> flyExemptions = new HashMap<UUID, Long>();
    public static int CHECK_FREQUENCY = 20;

    public NCPAPI(Plugin plugin, Plugin ncpPlugin) {
        plugin.getServer().getScheduler().scheduleSyncRepeatingTask(plugin, (Runnable)this, (long)CHECK_FREQUENCY, (long)CHECK_FREQUENCY);
    }

    @Override
    public void run() {
        ArrayList<UUID> uuids = new ArrayList<UUID>(this.flyExemptions.keySet());
        long now = System.currentTimeMillis();
        for (UUID uuid : uuids) {
            long timeout = this.flyExemptions.get(uuid);
            if (now <= timeout) continue;
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                NCPExemptionManager.unexempt((Player)player, (CheckType)CheckType.MOVING_SURVIVALFLY);
                NCPExemptionManager.unexempt((Player)player, (CheckType)CheckType.MOVING_CREATIVEFLY);
            }
            this.flyExemptions.remove(uuid);
        }
    }

    public void addFlightExemption(Player player, long duration) {
        UUID id = player.getUniqueId();
        long newTimeout = System.currentTimeMillis() + duration;
        Long timeout = this.flyExemptions.get(id);
        if (timeout == null || timeout < newTimeout) {
            NCPExemptionManager.exemptPermanently((Player)player, (CheckType)CheckType.MOVING_SURVIVALFLY);
            NCPExemptionManager.exemptPermanently((Player)player, (CheckType)CheckType.MOVING_CREATIVEFLY);
            this.flyExemptions.put(id, newTimeout);
        }
    }

    public void addFlightExemption(Player player) {
        NCPExemptionManager.exemptPermanently((Player)player, (CheckType)CheckType.MOVING_SURVIVALFLY);
        NCPExemptionManager.exemptPermanently((Player)player, (CheckType)CheckType.MOVING_CREATIVEFLY);
    }

    public void removeFlightExemption(Player player) {
        NCPExemptionManager.unexempt((Player)player, (CheckType)CheckType.MOVING_SURVIVALFLY);
        NCPExemptionManager.unexempt((Player)player, (CheckType)CheckType.MOVING_CREATIVEFLY);
    }
}

