/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.requirements;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.requirements.RangedRequirement;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.StringUtils;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

class ItemRequirement
extends RangedRequirement {
    public final String itemKey;
    private ItemStack itemStack;

    private ItemRequirement(ConfigurationSection configuration) {
        super(configuration);
        this.itemKey = configuration.getString("item", "");
    }

    private ItemRequirement(String[] configValues) {
        super(configValues[configValues.length - 1]);
        this.itemKey = configValues[0];
    }

    private ItemRequirement(String configValue) {
        this(StringUtils.split(configValue, " "));
    }

    @Nullable
    public static ItemRequirement parse(ConfigurationSection configuration, String key) {
        ConfigurationSection rangedConfig = ConfigurationUtils.getConfigurationSection(configuration, key);
        if (rangedConfig != null) {
            return new ItemRequirement(rangedConfig);
        }
        if (configuration.contains(key)) {
            return new ItemRequirement(configuration.getString(key));
        }
        return null;
    }

    public boolean check(Mage mage) {
        ItemStack itemStack = this.getItemStack(mage.getController());
        if (itemStack == null) {
            return false;
        }
        return this.check(Double.valueOf(mage.getItemCount(itemStack)));
    }

    @Nullable
    public ItemStack getItemStack(MageController controller) {
        if (this.itemStack == null && this.itemKey != null) {
            ItemData itemData = controller.getOrCreateItem(this.itemKey);
            if (itemData == null) {
                controller.getLogger().warning("Invalid item in requirement: " + this.itemKey);
            } else {
                this.itemStack = itemData.getItemStack(1);
            }
        }
        return this.itemStack;
    }

    public String getKey() {
        return this.itemKey;
    }

    @Override
    public String toString() {
        return "[Item " + this.itemKey + "=" + this.value + " from (" + this.min + " to " + this.max + ")]";
    }
}

