/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.requirements;

import org.bukkit.configuration.ConfigurationSection;

class RangedRequirement {
    public Double max;
    public Double min;
    public Double value;
    public boolean inclusive = false;

    protected RangedRequirement() {
    }

    public RangedRequirement(String value) {
        try {
            if (value.startsWith("<")) {
                if (value.startsWith("<=")) {
                    this.max = Double.parseDouble(value.substring(2));
                    this.inclusive = true;
                } else {
                    this.max = Double.parseDouble(value.substring(1));
                }
            } else if (value.startsWith(">")) {
                if (value.startsWith(">=")) {
                    this.min = Double.parseDouble(value.substring(2));
                    this.inclusive = true;
                } else {
                    this.min = Double.parseDouble(value.substring(1));
                }
            } else if (value.startsWith("=")) {
                this.value = Double.parseDouble(value.substring(1));
            } else {
                this.min = Double.parseDouble(value);
                this.inclusive = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RangedRequirement(ConfigurationSection configuration) {
        if (configuration.contains("min")) {
            this.min = configuration.getDouble("min");
        }
        if (configuration.contains("max")) {
            this.max = configuration.getDouble("max");
        }
        if (configuration.contains("value")) {
            this.value = configuration.getDouble("value");
        }
        this.inclusive = configuration.getBoolean("inclusive");
    }

    public boolean check(Double value) {
        if (!(this.value == null || value != null && value.equals(this.value))) {
            return false;
        }
        if (this.inclusive) {
            if (this.min != null && (value == null || value < this.min)) {
                return false;
            }
            if (this.max != null && value != null && value > this.max) {
                return false;
            }
        } else {
            if (this.min != null && (value == null || value <= this.min)) {
                return false;
            }
            if (this.max != null && value != null && value >= this.max) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "[Require =" + this.value + " from (" + this.min + " to " + this.max + ")]";
    }
}

