/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.resourcepack;

import com.google.common.io.BaseEncoding;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public class ResourcePack {
    @Nonnull
    private final String key;
    @Nonnull
    private String url;
    @Nonnull
    private Date modified;
    @Nullable
    private byte[] hash;
    private boolean checked = false;

    public ResourcePack(String url) {
        this.key = ResourcePack.getKey(url);
        this.url = url;
        this.modified = new Date(0L);
        this.hash = null;
    }

    public ResourcePack(String url, byte[] hash, Date modified) {
        this.key = ResourcePack.getKey(url);
        this.url = url;
        this.hash = hash;
        this.modified = modified;
    }

    public ResourcePack(String key, ConfigurationSection configuration) {
        this.key = key;
        this.url = configuration.getString("url");
        String hashString = configuration.getString("sha1");
        this.hash = (byte[])(hashString != null && hashString.length() < 40 ? BaseEncoding.base64().decode((CharSequence)hashString) : null);
        Long modifiedEpoch = configuration.getLong("modified");
        this.modified = new Date(modifiedEpoch);
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Nullable
    public byte[] getHash() {
        return this.hash;
    }

    @Nullable
    public String getHashString() {
        return this.hash == null ? null : BaseEncoding.base64().encode(this.hash);
    }

    @Nonnull
    public Date getModified() {
        return this.modified;
    }

    @Nonnull
    public static String getKey(String url) {
        return url.replace(".", "_");
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public void save(ConfigurationSection configuration) {
        configuration.set("url", (Object)this.url);
        configuration.set("modified", (Object)this.modified.getTime());
        if (this.hash != null) {
            configuration.set("sha1", (Object)this.getHashString());
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public void update(byte[] hash, Date modified) {
        this.hash = hash;
        this.modified = modified;
    }
}

