/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.tasks;

import com.elmakers.mine.bukkit.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class TeleportTask
implements Runnable {
    protected static final int TELEPORT_RETRY_COUNT = 8;
    protected static final int TELEPORT_RETRY_INTERVAL = 1;
    private final CastContext context;
    private final Entity entity;
    private final Location location;
    private final int verticalSearchDistance;
    private final MageController controller;
    private final boolean preventFall;
    private final boolean safe;
    private int retryCount;

    public TeleportTask(MageController controller, Entity entity, Location location, int verticalSearchDistance, boolean preventFall, boolean safe, CastContext context) {
        this.context = context;
        this.entity = entity;
        this.location = location;
        this.verticalSearchDistance = verticalSearchDistance;
        this.controller = controller;
        this.retryCount = 8;
        this.preventFall = preventFall;
        this.safe = safe;
    }

    @Override
    public void run() {
        if (CompatibilityLib.getCompatibilityUtils().checkChunk(this.location)) {
            if (this.retryCount > 0) {
                --this.retryCount;
                Plugin plugin = this.controller.getPlugin();
                Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, (Runnable)this, 1L);
            }
            return;
        }
        Location targetLocation = this.location;
        if (this.context != null) {
            targetLocation = this.context.findPlaceToStand(this.location, this.verticalSearchDistance);
        }
        if (targetLocation == null && !this.preventFall) {
            Block block = this.location.getBlock();
            Block blockOneUp = block.getRelative(BlockFace.UP);
            if (!this.safe || this.context.isOkToStandIn(blockOneUp) && this.context.isOkToStandIn(block)) {
                targetLocation = this.location;
            }
        }
        if (targetLocation != null) {
            targetLocation.setX(this.location.getX() - (double)this.location.getBlockX() + (double)targetLocation.getBlockX());
            targetLocation.setZ(this.location.getZ() - (double)this.location.getBlockZ() + (double)targetLocation.getBlockZ());
            if (this.context != null) {
                this.context.registerMoved(this.entity);
            }
            boolean isWorldChange = !targetLocation.getWorld().equals((Object)this.entity.getWorld());
            this.entity.teleport(targetLocation);
            if (isWorldChange) {
                this.entity.teleport(targetLocation);
            }
            if (this.context != null) {
                this.context.setTargetLocation(targetLocation);
                this.context.sendMessageKey("teleport");
                this.context.playEffects("teleport");
            }
        } else if (this.context != null) {
            this.context.sendMessageKey("teleport_failed");
            this.context.playEffects("teleport_failed");
        }
    }
}

