/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.data.SerializedLocation;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.configuration.TranslatingConfigurationSection;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockVector;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ConfigUtils {
    public static Random random = new Random();

    public static List<ConfigurationSection> getNodeList(ConfigurationSection node, String path) {
        ArrayList<ConfigurationSection> results = new ArrayList<ConfigurationSection>();
        List mapList = node.getMapList(path);
        for (Map map : mapList) {
            results.add(ConfigUtils.toConfigurationSection(node, map));
        }
        return results;
    }

    public static ConfigurationSection newSection(ConfigurationSection parent) {
        return ConfigUtils.newSection(parent, "");
    }

    public static ConfigurationSection newSection(ConfigurationSection parent, String path) {
        if (parent instanceof TranslatingConfigurationSection) {
            return ((TranslatingConfigurationSection)parent).newSection(path);
        }
        return new TranslatingConfigurationSection(parent, path);
    }

    public static ConfigurationSection toConfigurationSection(ConfigurationSection parent, Map<?, ?> nodeMap) {
        return ConfigUtils.toConfigurationSection(parent, "", nodeMap);
    }

    public static ConfigurationSection toConfigurationSection(ConfigurationSection parent, String path, Map<?, ?> nodeMap) {
        ConfigurationSection newSection = ConfigUtils.newSection(parent, path);
        for (Map.Entry<?, ?> entry : nodeMap.entrySet()) {
            newSection.set(entry.getKey().toString(), entry.getValue());
        }
        return newSection;
    }

    public static ConfigurationSection convertConfigurationSection(Map<?, ?> nodeMap) {
        MemoryConfiguration newSection = new MemoryConfiguration();
        for (Map.Entry<?, ?> entry : nodeMap.entrySet()) {
            ConfigUtils.set((ConfigurationSection)newSection, entry.getKey().toString(), entry.getValue());
        }
        return newSection;
    }

    public static ConfigurationSection toStringConfiguration(Map<String, String> stringMap) {
        if (stringMap == null) {
            return null;
        }
        MemoryConfiguration configMap = new MemoryConfiguration();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            configMap.set(entry.getKey(), (Object)entry.getValue());
        }
        return configMap;
    }

    public static void set(ConfigurationSection node, String path, Object value) {
        if (value == null) {
            node.set(path, null);
            return;
        }
        boolean isTrue = value.equals("true");
        boolean isFalse = value.equals("false");
        if (isTrue || isFalse) {
            node.set(path, (Object)isTrue);
            return;
        }
        try {
            Integer i = value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
            node.set(path, (Object)i);
        }
        catch (Exception ex) {
            try {
                double d = value instanceof Double ? (Double)value : (value instanceof Float ? (double)((Float)value).floatValue() : Double.parseDouble(value.toString()));
                node.set(path, (Object)d);
            }
            catch (Exception ex2) {
                node.set(path, value);
            }
        }
    }

    public static ConfigurationSection getConfigurationSection(ConfigurationSection base, String key) {
        ConfigurationSection section = base.getConfigurationSection(key);
        if (section != null) {
            return section;
        }
        Object value = base.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof ConfigurationSection) {
            return (ConfigurationSection)value;
        }
        if (value instanceof Map) {
            ConfigurationSection newChild = base.createSection(key);
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                newChild.set((String)entry.getKey(), entry.getValue());
            }
            base.set(key, (Object)newChild);
            return newChild;
        }
        return null;
    }

    public static boolean isMaxValue(String stringValue) {
        if (stringValue == null) {
            return false;
        }
        return stringValue.equalsIgnoreCase("infinite") || stringValue.equalsIgnoreCase("forever") || stringValue.equalsIgnoreCase("infinity") || stringValue.equalsIgnoreCase("max");
    }

    @Nullable
    public static List<Object> getList(ConfigurationSection section, String path) {
        List list = section.getList(path);
        if (list != null) {
            return list;
        }
        Object o = section.get(path);
        return ConfigUtils.getList(o);
    }

    @Nullable
    public static List<Object> getList(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            return new ArrayList<Object>(Arrays.asList(StringUtils.split((String)o, ',')));
        }
        ArrayList<Object> single = new ArrayList<Object>();
        single.add(o);
        return single;
    }

    public static List<String> getStringList(ConfigurationSection section, String path, List<String> def) {
        ArrayList list = ConfigUtils.getStringList(section, path);
        return list == null ? (def == null ? new ArrayList() : def) : list;
    }

    @Nullable
    public static List<String> getStringList(ConfigurationSection section, String path) {
        List<Object> raw = ConfigUtils.getList(section, path);
        return ConfigUtils.getStringList(raw);
    }

    @Nullable
    public static List<String> getStringList(ConfigurationSection section, String path, String delimiter) {
        if (section.isList(path)) {
            List<Object> raw = ConfigUtils.getList(section, path);
            return ConfigUtils.getStringList(raw);
        }
        String value = section.getString(path);
        if (value == null) {
            return null;
        }
        String[] pieces = StringUtils.split(value, delimiter);
        return Arrays.asList(pieces);
    }

    @Nullable
    public static List<String> getStringList(Object o) {
        List<Object> raw = ConfigUtils.getList(o);
        return ConfigUtils.getStringList(raw);
    }

    @Nullable
    public static List<String> getStringList(List<Object> rawList) {
        if (rawList == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : rawList) {
            if (o == null || o instanceof ConfigurationSection || o instanceof List || o instanceof Map) continue;
            list.add(o.toString());
        }
        return list;
    }

    @Nullable
    public static List<PotionEffect> getPotionEffectObjects(ConfigurationSection baseConfig, String key, Logger log) {
        return ConfigUtils.getPotionEffectObjects(baseConfig, key, log, Integer.MAX_VALUE, 0, true, false);
    }

    @Nullable
    public static List<PotionEffect> getPotionEffectObjects(ConfigurationSection baseConfig, String key, Logger log, int defaultDuration) {
        return ConfigUtils.getPotionEffectObjects(baseConfig, key, log, defaultDuration, 0, true, true);
    }

    @Nullable
    public static List<PotionEffect> getPotionEffectObjects(ConfigurationSection baseConfig, String key, Logger log, int defaultDuration, int defaultAmplifier, boolean defaultAmbient, boolean defaultParticles) {
        ArrayList<PotionEffect> potionEffects = null;
        List<Object> genericList = ConfigUtils.getList(baseConfig, key);
        if (genericList != null && !genericList.isEmpty()) {
            potionEffects = new ArrayList<PotionEffect>();
            for (Object genericEntry : genericList) {
                ConfigurationSection potionEffectSection;
                PotionEffectType effectType;
                if (genericEntry instanceof String) {
                    String typeString = (String)genericEntry;
                    effectType = PotionEffectType.getByName((String)typeString.toUpperCase());
                    if (effectType == null) {
                        log.log(Level.WARNING, "Invalid potion effect type: " + typeString);
                        continue;
                    }
                    int ticks = defaultDuration / 50;
                    potionEffects.add(new PotionEffect(effectType, effectType.isInstant() ? 1 : ticks, defaultAmplifier, defaultAmbient, defaultParticles));
                    continue;
                }
                ConfigurationSection configurationSection = potionEffectSection = genericEntry instanceof ConfigurationSection ? (ConfigurationSection)genericEntry : null;
                if (potionEffectSection == null && genericEntry instanceof Map) {
                    potionEffectSection = ConfigUtils.toConfigurationSection(baseConfig, (Map)genericEntry);
                }
                if (potionEffectSection == null) continue;
                if (potionEffectSection.contains("type")) {
                    effectType = PotionEffectType.getByName((String)potionEffectSection.getString("type").toUpperCase());
                    if (effectType == null) {
                        log.log(Level.WARNING, "Invalid potion effect type: " + potionEffectSection.getString("type", "(null)"));
                        continue;
                    }
                    int ticks = Integer.MAX_VALUE;
                    String duration = potionEffectSection.getString("duration");
                    if (duration == null || !duration.equals("forever") && !duration.equals("infinite") && !duration.equals("infinity")) {
                        ticks = (int)(potionEffectSection.getLong("duration", (long)defaultDuration) / 50L);
                        ticks = potionEffectSection.getInt("ticks", ticks);
                    }
                    int amplifier = potionEffectSection.getInt("amplifier", defaultAmplifier);
                    boolean ambient = potionEffectSection.getBoolean("ambient", defaultAmbient);
                    boolean particles = potionEffectSection.getBoolean("particles", defaultParticles);
                    potionEffects.add(new PotionEffect(effectType, effectType.isInstant() ? 1 : ticks, amplifier, ambient, particles));
                    continue;
                }
                Set types = potionEffectSection.getKeys(false);
                for (String type : types) {
                    PotionEffectType effectType2 = PotionEffectType.getByName((String)type.toUpperCase());
                    if (effectType2 == null) {
                        log.log(Level.WARNING, "Invalid potion effect type: " + type);
                        continue;
                    }
                    int amplifier = potionEffectSection.getInt(type, defaultAmplifier);
                    int ticks = defaultDuration / 50;
                    potionEffects.add(new PotionEffect(effectType2, effectType2.isInstant() ? 1 : ticks, amplifier, defaultAmbient, defaultParticles));
                }
            }
        }
        return potionEffects;
    }

    @Nullable
    public static EulerAngle getEulerAngle(ConfigurationSection node, String path) {
        Vector vector = ConfigUtils.getVector(node, path, null);
        return vector == null ? null : new EulerAngle(vector.getX(), vector.getY(), vector.getZ());
    }

    @Nullable
    public static Vector getVector(ConfigurationSection node, String path) {
        return ConfigUtils.getVector(node, path, null);
    }

    @Nullable
    public static Vector getVector(ConfigurationSection node, String path, Vector def) {
        return ConfigUtils.getVector(node, path, def, null, null);
    }

    @Nullable
    public static Vector getVector(ConfigurationSection node, String path, Vector def, Logger logger, String logContext) {
        Object o = node.get(path, null);
        if (o == null) {
            return def;
        }
        Vector result = ConfigUtils.toVector(o);
        if (result == null && logger != null) {
            if (logContext == null) {
                logContext = "unknown";
            }
            logger.warning("Invalid vector in " + logContext + ": " + o);
        }
        return result;
    }

    @Nullable
    public static Vector toVector(Object o) {
        if (o instanceof Vector) {
            return (Vector)o;
        }
        if (o instanceof ConfigurationSection) {
            ConfigurationSection config = (ConfigurationSection)o;
            return new Vector(config.getDouble("x"), config.getDouble("y"), config.getDouble("z"));
        }
        if (o instanceof String) {
            try {
                String[] pieces;
                String parse = (String)o;
                if (parse.isEmpty()) {
                    return null;
                }
                if (!parse.contains("r") && !parse.contains("R") && parse.contains(",")) {
                    parse = parse.replace(" ", "");
                    parse = parse.replace(",", " ");
                }
                if (parse.contains("|")) {
                    parse = parse.replace(" ", "");
                    parse = parse.replace("|", " ");
                }
                if ((pieces = StringUtils.split(parse, ' ')).length < 3) {
                    return null;
                }
                double x = ConfigUtils.parseDouble(pieces[0]);
                double y = ConfigUtils.parseDouble(pieces[1]);
                double z = ConfigUtils.parseDouble(pieces[2]);
                return new Vector(x, y, z);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    protected static double parseDouble(String s) throws NumberFormatException {
        if (s == null || s.isEmpty()) {
            return 0.0;
        }
        char firstChar = s.charAt(0);
        if (firstChar == 'r' || firstChar == 'R') {
            String[] pieces = StringUtils.split(s, "(,)");
            double min = Double.parseDouble(pieces[1].trim());
            double max = Double.parseDouble(pieces[2].trim());
            return random.nextDouble() * (max - min) + min;
        }
        return Double.parseDouble(s);
    }

    @Nullable
    public static Location getLocation(ConfigurationSection node, String path) {
        String stringData = node.getString(path);
        if (stringData == null) {
            return null;
        }
        return ConfigUtils.toLocation(stringData);
    }

    @Nullable
    public static SerializedLocation getSerializedLocation(ConfigurationSection node, String path) {
        String stringData = node.getString(path);
        if (stringData == null) {
            return null;
        }
        return ConfigUtils.toSerializedLocation(stringData);
    }

    @Nullable
    public static BlockFace toBlockFace(String s) {
        BlockFace face = null;
        try {
            face = BlockFace.valueOf((String)s.toUpperCase());
        }
        catch (Exception ex) {
            face = null;
        }
        return face;
    }

    public static String fromBlockFace(BlockFace face) {
        return face.name().toLowerCase();
    }

    public static String fromVector(Vector vector) {
        if (vector == null) {
            return "";
        }
        return vector.getX() + "," + vector.getY() + "," + vector.getZ();
    }

    @Nonnull
    public static String fromLocation(@Nullable Location location, @Nullable Location relativeTo) {
        if (location == null || location.getWorld() == null) {
            return "";
        }
        if (relativeTo != null && relativeTo.getWorld() == null) {
            return "";
        }
        if (relativeTo == null || !relativeTo.getWorld().equals((Object)location.getWorld())) {
            return ConfigUtils.fromLocation(location);
        }
        location = location.clone();
        location.subtract(relativeTo);
        String serialized = location.getX() + "," + location.getY() + "," + location.getZ();
        if (location.getPitch() != relativeTo.getPitch() || location.getYaw() != relativeTo.getYaw()) {
            serialized = serialized + "," + location.getYaw() + "," + location.getPitch();
        }
        return serialized;
    }

    @Nonnull
    public static String fromLocation(@Nullable Location location) {
        if (location == null) {
            return "";
        }
        if (location.getWorld() == null) {
            return "";
        }
        return location.getX() + "," + location.getY() + "," + location.getZ() + "," + location.getWorld().getName() + "," + location.getYaw() + "," + location.getPitch();
    }

    public static String fromSerializedLocation(SerializedLocation location) {
        if (location == null) {
            return "";
        }
        if (location.getWorld() == null) {
            return "";
        }
        return location.getX() + "," + location.getY() + "," + location.getZ() + "," + location.getWorldName() + "," + location.getYaw() + "," + location.getPitch();
    }

    @Nullable
    public static String getWorldName(String descriptor) {
        if (descriptor == null) {
            return null;
        }
        String[] pieces = StringUtils.split(descriptor, ',');
        return pieces.length > 3 ? pieces[3] : null;
    }

    @Nullable
    public static Location toLocation(Object o) {
        return ConfigUtils.toLocation(o, null);
    }

    @Nullable
    public static Location toLocation(Object o, Location relativeTo) {
        if (o instanceof Location) {
            return (Location)o;
        }
        SerializedLocation location = ConfigUtils.toSerializedLocation(o, relativeTo);
        return location == null ? null : location.asLocation();
    }

    @Nullable
    public static SerializedLocation toSerializedLocation(Object o) {
        return ConfigUtils.toSerializedLocation(o, null);
    }

    @Nullable
    public static SerializedLocation toSerializedLocation(Object o, Location relativeTo) {
        if (o instanceof SerializedLocation) {
            return (SerializedLocation)o;
        }
        if (o instanceof String) {
            try {
                String world;
                float pitch = 0.0f;
                float yaw = 0.0f;
                String[] pieces = StringUtils.split((String)o, ',');
                double x = ConfigUtils.parseDouble(pieces[0]);
                double y = ConfigUtils.parseDouble(pieces[1]);
                double z = ConfigUtils.parseDouble(pieces[2]);
                if (relativeTo != null && (pieces.length == 3 || pieces.length == 5)) {
                    world = relativeTo.getWorld().getName();
                    x += relativeTo.getX();
                    y += relativeTo.getY();
                    z += relativeTo.getZ();
                    if (pieces.length == 5) {
                        yaw = Float.parseFloat(pieces[3]);
                        pitch = Float.parseFloat(pieces[4]);
                    } else {
                        yaw = relativeTo.getYaw();
                        pitch = relativeTo.getPitch();
                    }
                } else {
                    world = pieces.length > 3 ? pieces[3] : ((World)Bukkit.getWorlds().get(0)).getName();
                    if (pieces.length > 5) {
                        yaw = Float.parseFloat(pieces[4]);
                        pitch = Float.parseFloat(pieces[5]);
                    }
                }
                return new SerializedLocation(world, new BlockVector(x, y, z), yaw, pitch);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    protected static int parseInt(String s) throws NumberFormatException {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        char firstChar = s.charAt(0);
        if (firstChar == 'r' || firstChar == 'R') {
            String[] pieces = StringUtils.split(s, "(,)");
            double min = Double.parseDouble(pieces[1].trim());
            double max = Double.parseDouble(pieces[2].trim());
            return (int)Math.floor(random.nextDouble() * (max - min) + min);
        }
        return (int)Math.floor(Double.parseDouble(s));
    }

    public static double overrideDouble(String override, double value) {
        if (override == null || override.length() == 0) {
            return value;
        }
        try {
            if (override.startsWith("~")) {
                override = override.substring(1);
                value += ConfigUtils.parseDouble(override);
            } else if (override.startsWith("*")) {
                override = override.substring(1);
                value *= ConfigUtils.parseDouble(override);
            } else {
                value = ConfigUtils.parseDouble(override);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected static double overrideDouble(ConfigurationSection node, double value, String nodeName) {
        String override = node.getString(nodeName);
        return ConfigUtils.overrideDouble(override, value);
    }

    @Nullable
    public static World overrideWorld(MageController controller, ConfigurationSection node, String path, World world, boolean canCreateWorlds) {
        return ConfigUtils.overrideWorld(controller, node.getString(path), world, canCreateWorlds);
    }

    @Nullable
    public static World overrideWorld(MageController controller, String worldName, World world, boolean canCreateWorlds) {
        World worldOverride;
        if (worldName == null || worldName.length() == 0) {
            return null;
        }
        if (worldName.charAt(0) == '~') {
            if (world == null) {
                return null;
            }
            String baseWorld = world.getName();
            worldName = worldName.substring(1);
            if ((worldName = worldName.trim()).charAt(0) == '-') {
                worldName = worldName.substring(1);
                worldName = worldName.trim();
                worldName = baseWorld.replace(worldName, "");
            } else {
                worldName = baseWorld + worldName;
            }
        }
        if ((worldOverride = Bukkit.getWorld((String)worldName)) == null) {
            if (canCreateWorlds && world != null) {
                Bukkit.getLogger().info("Creating/Loading world: " + worldName);
                worldOverride = controller.copyWorld(worldName, world);
                if (worldOverride == null) {
                    Bukkit.getLogger().warning("Failed to load world: " + worldName);
                    return null;
                }
            } else {
                Bukkit.getLogger().warning("Could not load world: " + worldName);
                return null;
            }
        }
        return worldOverride;
    }

    @Nullable
    public static Location overrideLocation(MageController controller, ConfigurationSection node, String basePath, Location location, boolean canCreateWorlds) {
        String xName = basePath + "x";
        String yName = basePath + "y";
        String zName = basePath + "z";
        String dxName = basePath + "dx";
        String dyName = basePath + "dy";
        String dzName = basePath + "dz";
        boolean hasPosition = node.contains(xName) || node.contains(yName) || node.contains(zName);
        boolean hasDirection = node.contains(dxName) || node.contains(dyName) || node.contains(dzName);
        World baseWorld = location == null ? null : location.getWorld();
        World worldOverride = ConfigUtils.overrideWorld(controller, node, basePath + "world", baseWorld, canCreateWorlds);
        if (!hasPosition && !hasDirection && worldOverride == null) {
            return null;
        }
        if (location == null) {
            if (worldOverride == null) {
                return null;
            }
            location = new Location(worldOverride, 0.0, 0.0, 0.0);
        } else {
            location = location.clone();
            if (worldOverride != null) {
                location.setWorld(worldOverride);
            }
        }
        if (hasPosition) {
            location.setX(ConfigUtils.overrideDouble(node, location.getX(), xName));
            location.setY(ConfigUtils.overrideDouble(node, location.getY(), yName));
            location.setZ(ConfigUtils.overrideDouble(node, location.getZ(), zName));
        }
        if (hasDirection) {
            Vector direction = location.getDirection();
            direction.setX(ConfigUtils.overrideDouble(node, direction.getX(), dxName));
            direction.setY(ConfigUtils.overrideDouble(node, direction.getY(), dyName));
            direction.setZ(ConfigUtils.overrideDouble(node, direction.getZ(), dzName));
            location.setDirection(direction);
        }
        return location;
    }

    public static Color getColor(ConfigurationSection node, String path, Color def) {
        Color o = ConfigUtils.toColor(node.get(path));
        return o == null ? def : o;
    }

    @Nullable
    public static Color toColor(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return Color.fromRGB((int)((Byte)o).byteValue());
        }
        if (o instanceof Integer) {
            return Color.fromRGB((int)((Integer)o));
        }
        if (o instanceof Double) {
            return Color.fromRGB((int)((int)((Double)o).doubleValue()));
        }
        if (o instanceof Float) {
            return Color.fromRGB((int)((int)((Float)o).floatValue()));
        }
        if (o instanceof Long) {
            return Color.fromRGB((int)((int)((Long)o).longValue()));
        }
        if (o instanceof String) {
            try {
                String s = (String)o;
                if (s.length() == 0) {
                    return null;
                }
                if (s.charAt(0) == '#') {
                    s = s.substring(1);
                }
                if (s.startsWith("rand")) {
                    return Color.fromRGB((int)random.nextInt(0x1000000));
                }
                int rgb = Integer.parseInt(s, 16);
                return Color.fromRGB((int)rgb);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (o instanceof ConfigurationSection) {
            ConfigurationSection config = (ConfigurationSection)o;
            ColorHD color = new ColorHD(config);
            return color.getColor();
        }
        return null;
    }

    public static Integer getInteger(ConfigurationSection node, String path, Integer def) {
        if (node.contains(path)) {
            String strVal = node.getString(path);
            try {
                return ConfigUtils.parseInt(strVal);
            }
            catch (NumberFormatException ex) {
                Bukkit.getLogger().warning("Failed to parse as integer: " + strVal);
            }
        }
        return def;
    }

    public static Double getDouble(ConfigurationSection node, String path, Double def) {
        if (node.contains(path)) {
            String strVal = node.getString(path);
            try {
                return ConfigUtils.parseDouble(strVal);
            }
            catch (NumberFormatException ex) {
                Bukkit.getLogger().warning("Failed to parse as number: " + strVal);
            }
        }
        return def;
    }

    public static Boolean getBoolean(ConfigurationSection node, String path, Boolean def) {
        if (node.contains(path)) {
            return node.getBoolean(path);
        }
        return def;
    }

    public static void addIfNotEmpty(String message, Collection<String> list) {
        if (message != null && !message.isEmpty()) {
            list.add(message);
        }
    }

    public static List<Integer> getIntegerList(ConfigurationSection section, String path) {
        List<Object> raw = ConfigUtils.getList(section, path);
        if (raw == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object o : raw) {
            Integer i = ConfigUtils.castInt(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    @Nullable
    private static Integer castInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (int)((Byte)o);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return (int)((Double)o).doubleValue();
        }
        if (o instanceof Float) {
            return (int)((Float)o).floatValue();
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static Boolean getOptionalBoolean(ConfigurationSection configuration, String key, Boolean def) {
        return configuration.contains(key) ? Boolean.valueOf(configuration.getBoolean(key)) : def;
    }

    @Nullable
    public static Boolean getOptionalBoolean(ConfigurationSection configuration, String key) {
        return ConfigUtils.getOptionalBoolean(configuration, key, null);
    }

    @Nullable
    public static Integer getOptionalInteger(ConfigurationSection configuration, String key, Integer def) {
        return configuration.contains(key) ? Integer.valueOf(configuration.getInt(key)) : def;
    }

    @Nullable
    public static Integer getOptionalInteger(ConfigurationSection configuration, String key) {
        return ConfigUtils.getOptionalInteger(configuration, key, null);
    }

    @Nullable
    public static Double getOptionalDouble(ConfigurationSection configuration, String key) {
        return configuration.contains(key) ? Double.valueOf(configuration.getDouble(key)) : null;
    }

    @Nullable
    public static Float getOptionalFloat(ConfigurationSection configuration, String key) {
        return configuration.contains(key) ? Float.valueOf((float)configuration.getDouble(key)) : null;
    }

    @Nonnull
    public static Map<String, Object> toMap(ConfigurationSection section) {
        return ConfigUtils.toTypedMap(section);
    }

    public static <T> Map<String, T> toTypedMap(ConfigurationSection section) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Set keys = section.getKeys(false);
        for (String key : keys) {
            map.put(key, section.get(key));
        }
        return map;
    }
}

