/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class HitboxUtils {
    private static final Map<EntityType, BoundingBox> hitboxes = new HashMap<EntityType, BoundingBox>();
    private static final Map<EntityType, Double> headSizes = new HashMap<EntityType, Double>();
    private static double hitboxScale = 1.0;
    private static double hitboxScaleY = 1.0;
    private static double hitboxSneakScaleY = 0.75;
    private static BoundingBox defaultHitbox;

    public static BoundingBox getHitbox(Block block) {
        int blockX = block.getX();
        int blockY = block.getY();
        int blockZ = block.getZ();
        return new BoundingBox((double)blockX + 0.001, (double)blockX + 0.999, (double)blockY + 0.001, (double)blockY + 0.999, (double)blockZ + 0.001, (double)blockZ + 0.999);
    }

    @Nullable
    public static BoundingBox getHitbox(Entity entity) {
        if (entity == null) {
            return null;
        }
        BoundingBox hitbox = hitboxes.get(entity.getType());
        if (hitbox != null) {
            return hitbox.center(entity.getLocation().toVector());
        }
        hitbox = CompatibilityLib.getCompatibilityUtils().getHitbox(entity);
        if (hitbox != null) {
            double scaleY = hitboxScaleY;
            if (entity instanceof Player && ((Player)entity).isSneaking()) {
                scaleY = hitboxSneakScaleY;
            }
            return hitbox.scaleFromBase(hitboxScale, scaleY);
        }
        return defaultHitbox.center(entity.getLocation().toVector());
    }

    public static void setHitboxScale(double scale) {
        hitboxScale = scale;
    }

    public static void setHitboxScaleY(double scaleY) {
        hitboxScaleY = scaleY;
    }

    public static void setHitboxSneakScaleY(double scaleY) {
        hitboxSneakScaleY = scaleY;
    }

    public static boolean isHeadshot(Entity target, Location hitLocation) {
        if (target == null) {
            return false;
        }
        Double headSize = headSizes.get(target.getType());
        if (headSize == null) {
            return false;
        }
        Location eyeLocation = null;
        eyeLocation = target instanceof LivingEntity ? ((LivingEntity)target).getEyeLocation() : target.getLocation();
        if (!eyeLocation.getWorld().equals((Object)hitLocation.getWorld())) {
            return false;
        }
        double distance = Math.abs(hitLocation.getY() - eyeLocation.getY());
        return distance <= headSize;
    }

    public static void configureHeadSizes(ConfigurationSection config) {
        headSizes.clear();
        Set keys = config.getKeys(false);
        for (String key : keys) {
            try {
                double size = config.getDouble(key);
                EntityType entityType = EntityType.valueOf((String)key.toUpperCase());
                if (!(size > 0.0)) continue;
                headSizes.put(entityType, size);
            }
            catch (Exception exception) {}
        }
    }

    public static void configureHitboxes(ConfigurationSection config) {
        hitboxes.clear();
        Set keys = config.getKeys(false);
        for (String key : keys) {
            try {
                Vector bounds = ConfigurationUtils.getVector(config, key);
                String upperKey = key.toUpperCase();
                double halfX = bounds.getX() / 2.0;
                double halfZ = bounds.getZ() / 2.0;
                BoundingBox bb = new BoundingBox(-halfX, halfX, 0.0, bounds.getY(), -halfZ, halfZ).scaleFromBase(hitboxScale, hitboxScaleY);
                if (upperKey.equals("DEFAULT")) {
                    defaultHitbox = bb;
                    continue;
                }
                EntityType entityType = EntityType.valueOf((String)upperKey);
                hitboxes.put(entityType, bb);
            }
            catch (Exception exception) {}
        }
    }
}

