/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.platform.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.platform.ItemUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import java.util.Objects;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class ItemUtilsBase
implements ItemUtils {
    protected final Platform platform;

    protected ItemUtilsBase(Platform platform) {
        this.platform = platform;
    }

    @Override
    public void addGlow(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        stack.setItemMeta(meta);
    }

    @Override
    public void removeGlow(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        meta.setEnchantmentGlintOverride(null);
        stack.setItemMeta(meta);
    }

    @Override
    public void makeTemporary(ItemStack itemStack, String message) {
        this.platform.getNBTUtils().setString(itemStack, "temporary", message);
    }

    @Override
    public boolean isTemporary(ItemStack itemStack) {
        return this.platform.getNBTUtils().containsTag(itemStack, "temporary");
    }

    @Override
    public void makeUnplaceable(ItemStack itemStack) {
        this.platform.getNBTUtils().setString(itemStack, "unplaceable", "true");
    }

    @Override
    public void removeUnplaceable(ItemStack itemStack) {
        this.platform.getNBTUtils().removeMeta(itemStack, "unplaceable");
    }

    @Override
    public boolean isUnplaceable(ItemStack itemStack) {
        return this.platform.getNBTUtils().containsTag(itemStack, "unplaceable");
    }

    @Override
    public String getTemporaryMessage(ItemStack itemStack) {
        return this.platform.getNBTUtils().getString(itemStack, "temporary");
    }

    @Override
    public void setReplacement(ItemStack itemStack, ItemStack replacement) {
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.set("item", (Object)replacement);
        this.platform.getNBTUtils().setString(itemStack, "replacement", configuration.saveToString());
    }

    @Override
    public ItemStack getReplacement(ItemStack itemStack) {
        String serialized = this.platform.getNBTUtils().getString(itemStack, "replacement");
        if (serialized == null || serialized.isEmpty()) {
            return null;
        }
        YamlConfiguration configuration = new YamlConfiguration();
        ItemStack replacement = null;
        try {
            configuration.loadFromString(serialized);
            replacement = configuration.getItemStack("item");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return replacement;
    }

    @Override
    public boolean isSameItem(ItemStack first, ItemStack second) {
        if (first.getType() != second.getType()) {
            return false;
        }
        DeprecatedUtils deprecatedUtils = this.platform.getDeprecatedUtils();
        if (deprecatedUtils.getItemDamage(first) != deprecatedUtils.getItemDamage(second)) {
            return false;
        }
        return this.hasSameTags(first, second);
    }

    @Override
    public boolean hasSameTags(ItemStack first, ItemStack second) {
        Object firstTag = this.getTag(first);
        Object secondTag = this.getTag(second);
        return Objects.equals(firstTag, secondTag);
    }

    @Override
    public int getCustomModelData(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return 0;
        }
        if (!itemMeta.hasCustomModelData()) {
            return 0;
        }
        return itemMeta.getCustomModelData();
    }

    @Override
    public void setCustomModelData(ItemStack itemStack, int customModelData) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.setCustomModelData(Integer.valueOf(customModelData));
        itemStack.setItemMeta(itemMeta);
    }

    @Override
    public Object getOrCreateTag(Object mcItemStack) {
        return this.getTag(mcItemStack);
    }

    @Override
    public Object getOrCreateTag(ItemStack itemStack) {
        return this.getTag(itemStack);
    }

    @Override
    public ItemStack makeReal(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Object nmsStack = this.getHandle(stack);
        if (nmsStack == null) {
            stack = this.getCopy(stack);
            nmsStack = this.getHandle(stack);
        }
        if (nmsStack == null) {
            return null;
        }
        return stack;
    }

    @Override
    public boolean isUnbreakable(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        return meta.isUnbreakable();
    }

    @Override
    public void makeUnbreakable(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        meta.setUnbreakable(true);
        stack.setItemMeta(meta);
    }

    @Override
    public void removeUnbreakable(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        meta.setUnbreakable(false);
        stack.setItemMeta(meta);
    }

    @Override
    public void hideFlags(ItemStack stack, int flags) {
        if (this.isEmpty(stack)) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        ItemFlag[] flagArray = ItemFlag.values();
        for (int ordinal = 0; ordinal < flagArray.length; ++ordinal) {
            ItemFlag flag = flagArray[ordinal];
            if ((flags & 1) == 1) {
                meta.addItemFlags(new ItemFlag[]{flag});
            } else {
                meta.removeItemFlags(new ItemFlag[]{flag});
            }
            flags >>= 1;
        }
        stack.setItemMeta(meta);
    }
}

