/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.OfflinePlayerCallback;
import com.elmakers.mine.bukkit.utility.ProfileCallback;
import com.elmakers.mine.bukkit.utility.ProfileResponse;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.SkinUtils;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;

public class SkinUtilsBase
implements SkinUtils {
    protected final Platform platform;
    protected final Map<UUID, ProfileResponse> responseCache = new HashMap<UUID, ProfileResponse>();
    protected final Map<String, Object> loadingUUIDs = new HashMap<String, Object>();
    protected final Map<UUID, Object> loadingProfiles = new HashMap<UUID, Object>();
    protected long holdoff = 0L;

    protected SkinUtilsBase(Platform platform) {
        this.platform = platform;
    }

    @Override
    public String getOnlineSkinURL(Player player) {
        PlayerProfile playerProfile = player.getPlayerProfile();
        URL skinURL = playerProfile == null ? null : playerProfile.getTextures().getSkin();
        return skinURL == null ? null : skinURL.toString();
    }

    @Override
    public String getOnlineSkinURL(String playerName) {
        if (playerName.startsWith("http")) {
            return playerName;
        }
        Player player = this.platform.getDeprecatedUtils().getPlayerExact(playerName);
        String url = null;
        if (player != null) {
            url = this.getOnlineSkinURL(player);
        }
        return url;
    }

    private void engageHoldoff() {
        this.holdoff = 600000L;
    }

    private void synchronizeCallbackOfflinePlayer(final OfflinePlayerCallback callback, final OfflinePlayer offlinePlayer) {
        Bukkit.getScheduler().runTask(this.platform.getPlugin(), new Runnable(){

            @Override
            public void run() {
                callback.result(offlinePlayer);
            }
        });
    }

    private void synchronizeCallbackProfile(final ProfileCallback callback, final ProfileResponse response) {
        Bukkit.getScheduler().runTask(this.platform.getPlugin(), new Runnable(){

            @Override
            public void run() {
                callback.result(response);
            }
        });
    }

    private void fetchOfflinePlayer(final String playerName, final OfflinePlayerCallback callback) {
        Player onlinePlayer = this.platform.getDeprecatedUtils().getPlayerExact(playerName);
        if (onlinePlayer != null) {
            callback.result((OfflinePlayer)onlinePlayer);
            return;
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously(this.platform.getPlugin(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object lock;
                Object object = SkinUtilsBase.this.loadingUUIDs;
                synchronized (object) {
                    lock = SkinUtilsBase.this.loadingUUIDs.get(playerName);
                    if (lock == null) {
                        lock = new Object();
                        SkinUtilsBase.this.loadingUUIDs.put(playerName, lock);
                    }
                }
                object = lock;
                synchronized (object) {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
                    if (offlinePlayer == null || offlinePlayer.getUniqueId() == null) {
                        SkinUtilsBase.this.engageHoldoff();
                        if (CompatibilityConstants.DEBUG) {
                            SkinUtilsBase.this.platform.getLogger().warning("Failed to request offline player data for " + playerName + ", will not retry for 10 minutes");
                        }
                    }
                    SkinUtilsBase.this.synchronizeCallbackOfflinePlayer(callback, offlinePlayer);
                }
            }
        }, this.holdoff / 50L);
    }

    @Override
    public void fetchProfile(String playerName, final ProfileCallback callback) {
        this.fetchOfflinePlayer(playerName, new OfflinePlayerCallback(){

            @Override
            public void result(OfflinePlayer offlinePlayer) {
                if (offlinePlayer != null) {
                    SkinUtilsBase.this.fetchProfile(offlinePlayer, callback);
                } else {
                    callback.result(null);
                }
            }
        });
    }

    @Override
    public void fetchProfile(UUID uuid, ProfileCallback callback) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        this.fetchProfile(offlinePlayer, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchProfile(final OfflinePlayer offlinePlayer, final ProfileCallback callback) {
        ProfileResponse cached;
        UUID uuid;
        UUID uUID = uuid = offlinePlayer == null ? null : offlinePlayer.getUniqueId();
        if (uuid == null) {
            callback.result(null);
            return;
        }
        Map<UUID, ProfileResponse> map = this.responseCache;
        synchronized (map) {
            cached = this.responseCache.get(uuid);
        }
        if (cached != null) {
            callback.result(cached);
            return;
        }
        Plugin plugin = this.platform.getPlugin();
        Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object lock;
                Object object = SkinUtilsBase.this.loadingProfiles;
                synchronized (object) {
                    lock = SkinUtilsBase.this.loadingProfiles.get(uuid);
                    if (lock == null) {
                        lock = new Object();
                        SkinUtilsBase.this.loadingProfiles.put(uuid, lock);
                    }
                }
                object = lock;
                synchronized (object) {
                    YamlConfiguration config;
                    ProfileResponse fromCache;
                    File playerCache;
                    ProfileResponse cached;
                    Map<UUID, ProfileResponse> map = SkinUtilsBase.this.responseCache;
                    synchronized (map) {
                        cached = SkinUtilsBase.this.responseCache.get(uuid);
                    }
                    if (cached != null) {
                        SkinUtilsBase.this.synchronizeCallbackProfile(callback, cached);
                        return;
                    }
                    File cacheFolder = new File(SkinUtilsBase.this.platform.getPlugin().getDataFolder(), "data/profiles");
                    if (!cacheFolder.exists()) {
                        cacheFolder.mkdirs();
                    }
                    if ((playerCache = new File(cacheFolder, uuid + ".yml")).exists() && SkinUtilsBase.this.isComplete((fromCache = new ProfileResponse((ConfigurationSection)(config = YamlConfiguration.loadConfiguration((File)playerCache)))).getPlayerProfile())) {
                        Map<UUID, ProfileResponse> map2 = SkinUtilsBase.this.responseCache;
                        synchronized (map2) {
                            SkinUtilsBase.this.responseCache.put(uuid, fromCache);
                        }
                        SkinUtilsBase.this.synchronizeCallbackProfile(callback, fromCache);
                        return;
                    }
                    PlayerProfile offlineProfile = offlinePlayer.getPlayerProfile();
                    if (!SkinUtilsBase.this.isComplete(offlineProfile)) {
                        if (CompatibilityConstants.DEBUG) {
                            SkinUtilsBase.this.platform.getLogger().info("Fetching offline player data for " + uuid);
                        }
                        try {
                            offlineProfile = (PlayerProfile)offlineProfile.update().get();
                        }
                        catch (Exception ex) {
                            if (CompatibilityConstants.DEBUG) {
                                SkinUtilsBase.this.platform.getLogger().log(Level.WARNING, "Failed to fetch profile for: " + uuid + ", will not retry for 10 minutes", ex);
                            } else {
                                SkinUtilsBase.this.platform.getLogger().log(Level.WARNING, "Failed to fetch profile for: " + uuid + ", will not retry for 10 minutes");
                            }
                            SkinUtilsBase.this.engageHoldoff();
                            SkinUtilsBase.this.synchronizeCallbackProfile(callback, null);
                            return;
                        }
                    }
                    if (!SkinUtilsBase.this.isComplete(offlineProfile)) {
                        SkinUtilsBase.this.platform.getLogger().log(Level.WARNING, "Got an empty player profile for: " + uuid + ", will not retry for 10 minutes");
                        SkinUtilsBase.this.engageHoldoff();
                        SkinUtilsBase.this.synchronizeCallbackProfile(callback, null);
                        return;
                    }
                    SkinUtilsBase.this.platform.getLogger().info("Got skin URL: " + offlineProfile.getTextures().getSkin() + " for " + offlineProfile.getName());
                    ProfileResponse response = new ProfileResponse(offlineProfile);
                    Map<UUID, ProfileResponse> map3 = SkinUtilsBase.this.responseCache;
                    synchronized (map3) {
                        SkinUtilsBase.this.responseCache.put(uuid, response);
                    }
                    try {
                        YamlConfiguration saveToCache = new YamlConfiguration();
                        response.save((ConfigurationSection)saveToCache);
                        saveToCache.save(playerCache);
                    }
                    catch (Exception ex) {
                        SkinUtilsBase.this.platform.getLogger().log(Level.WARNING, "Failed to save player profile to cache for: " + uuid, ex);
                    }
                    SkinUtilsBase.this.synchronizeCallbackProfile(callback, response);
                    SkinUtilsBase.this.holdoff = 0L;
                }
            }
        }, this.holdoff / 50L);
    }

    private boolean isComplete(PlayerProfile playerProfile) {
        return playerProfile != null && playerProfile.getUniqueId() != null && playerProfile.getName() != null && !playerProfile.getTextures().isEmpty();
    }
}

