/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.entity.SpawnedEntityExtraData;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.platform.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.platform.InventoryUtils;
import com.elmakers.mine.bukkit.utility.platform.PlatformInterpreter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapView;

public class EntityItemFrameData
extends EntityExtraData {
    protected Rotation rotation;
    protected ItemStack item;
    protected BlockFace facing;

    public EntityItemFrameData(ItemStack item, BlockFace facing, Rotation rotation) {
        this.item = item;
        this.facing = facing;
        this.rotation = rotation;
    }

    public EntityItemFrameData(ConfigurationSection parameters, MageController controller) {
        String itemKey;
        String rotationString;
        Logger log = controller.getLogger();
        String facingString = parameters.getString("facing");
        if (facingString != null && !facingString.isEmpty()) {
            try {
                this.facing = BlockFace.valueOf((String)facingString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid facing: " + facingString, ex);
            }
        }
        if ((rotationString = parameters.getString("rotation")) != null && !rotationString.isEmpty()) {
            try {
                this.rotation = Rotation.valueOf((String)rotationString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid rotation: " + rotationString, ex);
            }
        }
        if ((itemKey = parameters.getString("item")) != null && !itemKey.isEmpty()) {
            ItemData itemData = controller.getOrCreateItem(itemKey);
            if (itemData == null) {
                log.warning("Invalid item in item frame config: " + itemKey);
            } else {
                this.item = itemData.getItemStack();
            }
        }
    }

    public EntityItemFrameData(Entity entity) {
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            this.item = PlatformInterpreter.getPlatform().getItemUtils().getCopy(itemFrame.getItem());
            this.rotation = itemFrame.getRotation();
            this.facing = itemFrame.getFacing();
        }
    }

    @Override
    public void apply(Entity entity) {
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            if (!PlatformInterpreter.getPlatform().getItemUtils().isEmpty(this.item)) {
                itemFrame.setItem(this.item);
            }
            if (this.facing != null) {
                itemFrame.setFacingDirection(this.facing, true);
            }
            itemFrame.setRotation(this.rotation);
        }
    }

    @Override
    public SpawnedEntityExtraData spawn(Location location) {
        ItemFrame newEntity = PlatformInterpreter.getPlatform().getCompatibilityUtils().createItemFrame(location, this.facing, this.rotation, this.item);
        return new SpawnedEntityExtraData((Entity)newEntity, false);
    }

    @Override
    public boolean cycle(Entity entity) {
        MapView mapView;
        if (!this.canCycle(entity)) {
            return false;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        ItemStack frameItem = itemFrame.getItem();
        InventoryUtils inventoryUtils = PlatformInterpreter.getPlatform().getInventoryUtils();
        DeprecatedUtils deprecatedUtils = PlatformInterpreter.getPlatform().getDeprecatedUtils();
        int mapId = inventoryUtils.getMapId(frameItem);
        if ((mapView = deprecatedUtils.getMap(++mapId)) == null && (mapView = deprecatedUtils.getMap(mapId = 0)) == null) {
            return false;
        }
        inventoryUtils.setMapId(frameItem, mapId);
        itemFrame.setItem(frameItem);
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        if (!(entity instanceof ItemFrame)) {
            return false;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        ItemStack frameItem = itemFrame.getItem();
        CompatibilityUtils compatibilityUtils = PlatformInterpreter.getPlatform().getCompatibilityUtils();
        return frameItem != null && compatibilityUtils.isFilledMap(frameItem.getType());
    }
}

