/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Zombie;

public class EntityZombieData
extends EntityExtraData {
    public Boolean isBaby;

    public EntityZombieData(ConfigurationSection configuration) {
        this.isBaby = ConfigUtils.getOptionalBoolean(configuration, "baby");
    }

    public EntityZombieData(Zombie zombie) {
        this.isBaby = EntityZombieData.getPlatform().getCompatibilityUtils().isAdult(zombie);
    }

    @Override
    public void apply(Entity entity) {
        if (!(entity instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)entity;
        if (this.isBaby != null) {
            if (this.isBaby.booleanValue()) {
                EntityZombieData.getPlatform().getCompatibilityUtils().setBaby(zombie);
            } else {
                EntityZombieData.getPlatform().getCompatibilityUtils().setAdult(zombie);
            }
        }
    }
}

