/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandSet;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class ActiveWandSet {
    private final String key;
    private ConfigurationSection configuration;
    private final Map<Wand, ConfigurationSection> wands = new HashMap<Wand, ConfigurationSection>();

    public ActiveWandSet(String key) {
        this.key = key;
    }

    public void add(Wand wand, ConfigurationSection config) {
        ConfigurationSection bonusConfig = null;
        if (config != null) {
            bonusConfig = config.getConfigurationSection("bonuses");
            if (this.configuration == null) {
                this.configuration = ConfigurationUtils.cloneConfiguration(config);
                this.configuration.set("bonuses", null);
            } else {
                ConfigurationSection templateBonus = this.configuration.getConfigurationSection("bonuses");
                this.configuration.set("bonuses", null);
                ConfigurationUtils.addConfigurations(this.configuration, config, false);
                this.configuration.set("bonuses", (Object)templateBonus);
            }
        }
        this.wands.put(wand, bonusConfig);
    }

    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    public boolean isActive(WandSet setTemplate) {
        int requiredCount;
        int n = requiredCount = setTemplate == null ? 0 : setTemplate.getRequiredCount();
        if (this.configuration != null) {
            requiredCount = this.configuration.getInt("required", requiredCount);
        }
        return this.wands.size() >= requiredCount;
    }

    public void applyBonuses() {
        for (Map.Entry<Wand, ConfigurationSection> entry : this.wands.entrySet()) {
            entry.getKey().applySetBonus(this.key, entry.getValue());
        }
    }
}

