/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.MageContext;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;

public class RequirementProperties {
    private final Collection<Requirement> requirements;
    private final ConfigurationSection properties;
    private boolean status;
    private boolean invert;

    public RequirementProperties(ConfigurationSection configuration) {
        this.requirements = ConfigurationUtils.getRequirements(configuration);
        this.properties = configuration.getConfigurationSection("properties");
        this.invert = configuration.getBoolean("invert", false);
    }

    public boolean check(MageContext context) {
        boolean bl = this.status = context.getController().checkRequirements(context, this.requirements) == null;
        if (this.invert) {
            this.status = !this.status;
        }
        return this.status;
    }

    public boolean hasChanged(MageContext context) {
        boolean current = this.status;
        return this.check(context) != current;
    }

    public boolean isEmpty() {
        return this.requirements == null || this.requirements.isEmpty() || this.properties == null || this.properties.getKeys(false).isEmpty();
    }

    public boolean isAllowed() {
        return this.status;
    }

    public ConfigurationSection getProperties() {
        return this.properties;
    }
}

