/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAttribute;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public class WandDisplayMode {
    public static WandDisplayMode NONE = new WandDisplayMode(DisplayType.NONE);
    public static WandDisplayMode COOLDOWN = new WandDisplayMode(DisplayType.COOLDOWN);
    public static WandDisplayMode MANA = new WandDisplayMode(DisplayType.MANA);
    public static WandDisplayMode CHARGES = new WandDisplayMode(DisplayType.CHARGES);
    public static WandDisplayMode SP = new WandDisplayMode(DisplayType.CURRENCY, "sp");
    private final DisplayType displayType;
    private final String currencyKey;
    private final String attributeKey;

    private WandDisplayMode(DisplayType displayType, String extraData) {
        this.displayType = displayType;
        switch (displayType.ordinal()) {
            case 4: {
                this.currencyKey = extraData;
                this.attributeKey = null;
                break;
            }
            case 5: {
                this.attributeKey = extraData;
                this.currencyKey = null;
                break;
            }
            default: {
                this.attributeKey = null;
                this.currencyKey = null;
            }
        }
    }

    public WandDisplayMode(DisplayType displayType) {
        this(displayType, null);
    }

    public static WandDisplayMode getCurrency(String currencyKey) {
        return new WandDisplayMode(DisplayType.CURRENCY, currencyKey);
    }

    public static WandDisplayMode parse(String displayMode) {
        if (displayMode == null || displayMode.isEmpty()) {
            return null;
        }
        if (displayMode.equalsIgnoreCase("false")) {
            return NONE;
        }
        if (displayMode.equalsIgnoreCase("sp")) {
            return SP;
        }
        DisplayType displayType = DisplayType.valueOf(displayMode.toUpperCase());
        switch (displayType.ordinal()) {
            case 1: {
                return COOLDOWN;
            }
            case 2: {
                return MANA;
            }
            case 3: {
                return CHARGES;
            }
            case 0: {
                return NONE;
            }
        }
        throw new IllegalArgumentException("Unknown display type or can't specify as a simple string: " + String.valueOf((Object)displayType));
    }

    @Nonnull
    public static WandDisplayMode parse(MageController controller, ConfigurationSection config, String modeKey, WandDisplayMode defaultMode) {
        WandDisplayMode parsed = WandDisplayMode.parse(controller, config, modeKey);
        return parsed == null ? defaultMode : parsed;
    }

    @Nullable
    public static WandDisplayMode parse(MageController controller, ConfigurationSection config, String modeKey) {
        if (config == null) {
            return null;
        }
        String displayMode = config.getString(modeKey);
        if (displayMode == null || displayMode.isEmpty()) {
            return null;
        }
        DisplayType displayType = DisplayType.valueOf(displayMode.toUpperCase());
        switch (displayType.ordinal()) {
            case 1: {
                return COOLDOWN;
            }
            case 2: {
                return MANA;
            }
            case 3: {
                return CHARGES;
            }
            case 0: {
                return NONE;
            }
            case 4: {
                String currencyType = config.getString("currency");
                if (currencyType == null || currencyType.isEmpty()) {
                    throw new IllegalArgumentException("Currency type requires currency definition");
                }
                if (currencyType.equals("sp")) {
                    return SP;
                }
                if (controller.getCurrency(currencyType) == null) {
                    throw new IllegalArgumentException("Unknown currency in display mode: " + currencyType);
                }
                return new WandDisplayMode(DisplayType.CURRENCY, currencyType);
            }
            case 5: {
                String attributeType = config.getString("attribute");
                if (attributeType == null || attributeType.isEmpty()) {
                    throw new IllegalArgumentException("Currency type requires attribute definition");
                }
                return new WandDisplayMode(DisplayType.ATTRIBUTE, attributeType);
            }
        }
        throw new IllegalArgumentException("Unknown display type: " + String.valueOf((Object)displayType));
    }

    public double getProgress(Wand wand) {
        Mage mage = wand.getMage();
        Spell spell = wand.getActiveSpell();
        double progress = 1.0;
        switch (this.displayType.ordinal()) {
            case 1: {
                if (spell == null || !(spell instanceof MageSpell)) break;
                MageSpell mageSpell = (MageSpell)spell;
                Long timeToCast = mageSpell.getTimeToCast();
                long maxTimeToCast = mageSpell.getMaxTimeToCast();
                if (maxTimeToCast <= 0L || timeToCast == null) break;
                progress = (double)(maxTimeToCast - timeToCast) / (double)maxTimeToCast;
                break;
            }
            case 3: {
                if (spell == null) break;
                double charges = spell.getChargesRemaining();
                int maxCharges = spell.getMaxCharges();
                if (maxCharges <= 0) break;
                progress = charges / (double)maxCharges;
                break;
            }
            case 2: {
                double maxMana = mage.getEffectiveManaMax();
                if (!(maxMana > 0.0) || wand.isCostFree()) break;
                progress = (double)mage.getMana() / maxMana;
                break;
            }
            case 4: {
                Currency currency = mage.getController().getCurrency(this.currencyKey);
                progress = mage.getCurrency(this.currencyKey);
                if (currency == null || !currency.hasMaxValue()) break;
                progress /= currency.getMaxValue();
                break;
            }
            case 5: {
                Double maxValue;
                MagicAttribute attribute = mage.getController().getAttribute(this.attributeKey);
                progress = mage.getAttribute(this.attributeKey);
                Double d = maxValue = attribute != null ? attribute.getMax() : null;
                if (maxValue == null) break;
                progress /= maxValue.doubleValue();
                break;
            }
        }
        return progress;
    }

    public double getValue(Wand wand) {
        Mage mage = wand.getMage();
        double value = 1.0;
        Spell spell = wand.getActiveSpell();
        switch (this.displayType.ordinal()) {
            case 1: {
                MageSpell mageSpell;
                Long timeToCast;
                if (spell == null || !(spell instanceof MageSpell) || (timeToCast = (mageSpell = (MageSpell)spell).getTimeToCast()) == null) break;
                value = timeToCast / 1000L;
                break;
            }
            case 3: {
                if (spell == null) break;
                value = spell.getChargesRemaining();
                break;
            }
            case 2: {
                value = mage.getMana();
                break;
            }
            case 4: {
                value = mage.getCurrency(this.currencyKey);
                break;
            }
            case 5: {
                value = mage.getAttribute(this.attributeKey);
                break;
            }
        }
        return value;
    }

    public boolean isEnabled(Wand wand) {
        switch (this.displayType.ordinal()) {
            case 3: {
                return !wand.isCooldownFree();
            }
            case 1: {
                return !wand.isCooldownFree();
            }
            case 2: {
                return wand.usesMana();
            }
            case 4: {
                if (this.currencyKey.equals("sp")) {
                    return wand.usesSP();
                }
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean usesCurrency(String currencyKey) {
        return this.displayType == DisplayType.CURRENCY && this.currencyKey.equals(currencyKey);
    }

    public boolean usesMana() {
        return this.displayType == DisplayType.MANA;
    }

    public static void addOptions(Collection<String> options) {
        block3: for (DisplayType displayType : DisplayType.values()) {
            switch (displayType.ordinal()) {
                case 4: 
                case 5: {
                    continue block3;
                }
                default: {
                    options.add(displayType.name().toLowerCase());
                }
            }
        }
    }

    private static enum DisplayType {
        NONE,
        COOLDOWN,
        MANA,
        CHARGES,
        CURRENCY,
        ATTRIBUTE;

    }
}

