/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.warp;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.locations.NamedLocation;
import com.sk89q.commandbook.locations.RootLocationManager;
import com.sk89q.commandbook.locations.WarpsComponent;
import com.zachsthings.libcomponents.ComponentManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class CommandBookWarps {
    private final RootLocationManager<NamedLocation> locationManager;

    private CommandBookWarps(RootLocationManager<NamedLocation> locationManager) {
        this.locationManager = locationManager;
    }

    @Nullable
    public static CommandBookWarps create(Plugin plugin) {
        if (plugin instanceof CommandBook) {
            ComponentManager componentManager = ((CommandBook)plugin).getComponentManager();
            WarpsComponent component = (WarpsComponent)componentManager.getComponent(WarpsComponent.class);
            if (component == null) {
                return null;
            }
            RootLocationManager locationManager = component.getManager();
            return locationManager != null ? new CommandBookWarps((RootLocationManager<NamedLocation>)locationManager) : null;
        }
        return null;
    }

    @Nullable
    public Location getWarp(String warpName) {
        if (this.locationManager == null) {
            return null;
        }
        NamedLocation location = (NamedLocation)this.locationManager.get(null, warpName);
        if (location == null) {
            return null;
        }
        return location.getLocation();
    }

    public Map<String, Location> getWarps() {
        HashMap<String, Location> warps = new HashMap<String, Location>();
        List locations = this.locationManager.getLocations(null);
        for (NamedLocation location : locations) {
            warps.put(location.getName(), location.getLocation());
        }
        return warps;
    }
}

