/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world;

import com.elmakers.mine.bukkit.utility.StringUtils;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.spawn.SpawnResult;

public class CastSpell {
    private final String name;
    private final String[] parameters;
    private final SpawnResult spawnResult;
    private final BlockResult blockResult;

    public CastSpell(String commandLine) {
        if (commandLine == null || commandLine.isEmpty() || commandLine.equalsIgnoreCase("none")) {
            this.name = null;
            this.parameters = null;
            this.spawnResult = SpawnResult.REMOVE;
            this.blockResult = BlockResult.REMOVE_DROPS;
        } else if (commandLine.contains(" ")) {
            String[] pieces = StringUtils.split(commandLine, " ");
            this.name = pieces[0];
            this.parameters = new String[pieces.length - 1];
            for (int i = 1; i < pieces.length; ++i) {
                this.parameters[i - 1] = pieces[i];
            }
            this.spawnResult = SpawnResult.REMOVE;
            this.blockResult = BlockResult.REMOVE_DROPS;
        } else {
            boolean noSpell = false;
            SpawnResult spawnResult = SpawnResult.REMOVE;
            try {
                spawnResult = SpawnResult.valueOf(commandLine.toUpperCase());
                noSpell = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            BlockResult blockResult = BlockResult.REMOVE_DROPS;
            try {
                blockResult = BlockResult.valueOf(commandLine.toUpperCase());
                noSpell = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.name = noSpell ? null : commandLine;
            this.parameters = noSpell ? null : new String[]{};
            this.spawnResult = spawnResult;
            this.blockResult = blockResult;
        }
    }

    public boolean isEmpty() {
        return this.name == null;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public SpawnResult getSpawnResult() {
        return this.spawnResult;
    }

    public BlockResult getBlockResult() {
        return this.blockResult;
    }
}

