/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world;

import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.world.MagicWorld;
import com.elmakers.mine.bukkit.world.listener.WorldPlayerListener;
import com.elmakers.mine.bukkit.world.listener.WorldSpawnListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class WorldController
implements Listener {
    private final Map<String, MagicWorld> magicWorlds = new HashMap<String, MagicWorld>();
    private final MagicController controller;
    private final WorldPlayerListener playerListener;
    private final WorldSpawnListener spawnListener;
    private boolean removeInvalidEntities = false;

    public WorldController(MagicController controller) {
        this.controller = controller;
        this.playerListener = new WorldPlayerListener(this);
        this.spawnListener = new WorldSpawnListener(this);
    }

    public void registerEvents() {
        Plugin plugin = this.controller.getPlugin();
        PluginManager pm = plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this, plugin);
        pm.registerEvents((Listener)this.playerListener, plugin);
        pm.registerEvents((Listener)this.spawnListener, plugin);
    }

    public void load(ConfigurationSection configuration) {
        this.spawnListener.load(configuration);
        this.removeInvalidEntities = configuration.getBoolean("remove_invalid_entities");
        if (this.removeInvalidEntities) {
            this.controller.getLogger().info("Will remove out of bounds entities on chunk load");
        }
    }

    public void loadWorlds(ConfigurationSection configuration) {
        for (MagicWorld magicWorld : this.magicWorlds.values()) {
            magicWorld.remove();
        }
        this.magicWorlds.clear();
        ConfigurationSection legacyConfig = configuration.getConfigurationSection("worlds");
        if (legacyConfig != null) {
            this.controller.getLogger().info("Your world configuration contains a 'worlds' section, assuming this is a legacy MagicWorlds configuration");
            ConfigurationUtils.addConfigurations(configuration, legacyConfig, false);
            configuration.set("worlds", null);
        }
        Set worldKeys = configuration.getKeys(false);
        for (String worldName : worldKeys) {
            ConfigurationSection worldConfiguration = configuration.getConfigurationSection(worldName);
            if (worldConfiguration == null) {
                this.controller.getLogger().warning("Was expecting a properties section in world config for key '" + worldName + "', but got: " + String.valueOf(configuration.get(worldName)));
                continue;
            }
            if (!worldConfiguration.getBoolean("enabled", true)) continue;
            MagicWorld world = this.magicWorlds.get(worldName = worldConfiguration.getString("world", worldName));
            if (world == null) {
                world = new MagicWorld(this.controller);
            }
            try {
                world.load(worldName, worldConfiguration);
                this.magicWorlds.put(worldName, world);
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Unexpected error setting up customizations for world: " + worldName, ex);
            }
        }
        for (MagicWorld world : this.magicWorlds.values()) {
            world.finalizeLoad();
        }
    }

    public World createWorld(String worldName) {
        MagicWorld world = this.magicWorlds.get(worldName);
        if (world != null) {
            return world.checkWorldCreate();
        }
        return Bukkit.createWorld((WorldCreator)new WorldCreator(worldName));
    }

    public World copyWorld(String worldName, World copyFrom) {
        MagicWorld world = this.magicWorlds.get(worldName);
        if (world != null) {
            return world.copyWorld(copyFrom);
        }
        return Bukkit.createWorld((WorldCreator)new WorldCreator(worldName).copy(copyFrom));
    }

    public int getCount() {
        return this.magicWorlds.size();
    }

    @EventHandler
    public void onWorldInit(WorldInitEvent event) {
        BlockPopulator populator;
        World world = event.getWorld();
        if (this.removeInvalidEntities && (populator = CompatibilityLib.getCompatibilityUtils().createOutOfBoundsPopulator(this.controller.getLogger())) != null) {
            world.getPopulators().add(populator);
        }
        for (MagicWorld notifyWorld : this.magicWorlds.values()) {
            notifyWorld.onWorldInit(world);
        }
        MagicWorld magicWorld = this.magicWorlds.get(world.getName());
        if (magicWorld == null) {
            return;
        }
        this.controller.info("Initializing world " + world.getName());
        magicWorld.installPopulators(world);
    }

    public void onPlayerJoin(Mage mage) {
        MagicWorld magicWorld = this.getWorld(mage.getLocation().getWorld().getName());
        if (magicWorld == null) {
            MagicWorld.joinedDefault(mage);
            return;
        }
        magicWorld.playerJoined(mage);
    }

    public Plugin getPlugin() {
        return this.controller.getPlugin();
    }

    public MagicController getMagicController() {
        return this.controller;
    }

    public MagicWorld getWorld(String name) {
        return this.magicWorlds.get(name);
    }

    public Collection<MagicWorld> getWorlds() {
        return this.magicWorlds.values();
    }

    public Logger getLogger() {
        return this.controller.getLogger();
    }

    public boolean isDataLoaded() {
        return this.controller.isDataLoaded();
    }

    public void setDisableSpawnReplacement(boolean disable) {
        this.controller.setDisableSpawnReplacement(disable);
    }

    public boolean isDisableSpawnReplacement() {
        return this.controller.isDisableSpawnReplacement();
    }

    public WorldSpawnListener getSpawnListener() {
        return this.spawnListener;
    }
}

