/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.block;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.block.BlockRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MagicBlockHandler {
    public static final String BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.world.block.builtin";
    protected String worldName;
    protected String action;
    private final MagicController controller;
    private final Map<Material, List<BlockRule>> blockRules = new HashMap<Material, List<BlockRule>>();
    private final List<BlockRule> globalBlockRules = new ArrayList<BlockRule>();
    private Random random;

    public MagicBlockHandler(MagicController controller) {
        this.controller = controller;
    }

    public void load(String worldName, String action, ConfigurationSection config) {
        this.worldName = worldName;
        this.action = action;
        if (config == null) {
            return;
        }
        for (String key : config.getKeys(false)) {
            ConfigurationSection handlerConfig = config.getConfigurationSection(key);
            if (handlerConfig == null) {
                this.controller.getLogger().warning("Was expecting a properties section in world block event config for key '" + worldName + "', but got: " + String.valueOf(config.get(key)));
                continue;
            }
            if (!handlerConfig.getBoolean("enabled", true)) continue;
            String className = handlerConfig.getString("class");
            BlockRule rule = this.createBlockRule(className);
            if (rule != null) {
                if (rule.load(handlerConfig, this.controller, worldName, action)) {
                    if (rule.isGlobal()) {
                        this.globalBlockRules.add(rule);
                        continue;
                    }
                    for (Material targetBlock : rule.getBlockTypes()) {
                        List<BlockRule> rules = this.blockRules.get(targetBlock);
                        if (rules == null) {
                            rules = new ArrayList<BlockRule>();
                            this.blockRules.put(targetBlock, rules);
                        }
                        rules.add(rule);
                    }
                    continue;
                }
                this.controller.getLogger().warning("Skipping invalid " + key + " block rule for " + worldName);
                continue;
            }
            this.controller.getLogger().warning("Skipping invalid " + key + " block rule for " + worldName);
        }
    }

    private Random getRandom(World world) {
        if (this.random == null) {
            long seed = world == null ? System.currentTimeMillis() : world.getSeed();
            this.random = new Random(seed);
        }
        return this.random;
    }

    public BlockResult handleBlock(Block block, Player player) {
        Random random = this.getRandom(block.getWorld());
        for (BlockRule blockRule : this.globalBlockRules) {
            BlockResult result = blockRule.handle(block, random, player);
            if (result == BlockResult.SKIP) continue;
            return result;
        }
        List<BlockRule> rules = this.blockRules.get(block.getType());
        if (rules != null) {
            for (BlockRule blockRule : rules) {
                BlockResult result = blockRule.handle(block, random, player);
                if (result == BlockResult.SKIP) continue;
                return result;
            }
        }
        return BlockResult.SKIP;
    }

    @Nullable
    protected BlockRule createBlockRule(String className) {
        Object newObject;
        if (className == null) {
            return null;
        }
        if (((String)className).indexOf(46) <= 0 && !((String)(className = "com.elmakers.mine.bukkit.world.block.builtin." + (String)className)).endsWith("Rule")) {
            className = (String)className + "Rule";
        }
        Class<?> handlerClass = null;
        try {
            handlerClass = Class.forName((String)className);
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "Error loading block rule: " + (String)className, ex);
            return null;
        }
        try {
            newObject = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "Error loading block rule: " + (String)className, ex);
            return null;
        }
        if (newObject == null || !(newObject instanceof BlockRule)) {
            this.controller.getLogger().warning("Error loading block rule " + (String)className + ", does it extend BlockRule?");
            return null;
        }
        return (BlockRule)newObject;
    }

    public boolean isEmpty() {
        return this.globalBlockRules.size() == 0;
    }
}

