/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.block.builtin;

import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.block.magic.MagicBlock;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.elmakers.mine.bukkit.utility.random.WeightedPair;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.block.BlockRule;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MagicBlockRule
extends BlockRule {
    protected MaterialSet replace;
    protected Deque<WeightedPair<String>> templateProbability = new ArrayDeque<WeightedPair<String>>();
    protected ConfigurationSection parameters;

    @Override
    public boolean onLoad(ConfigurationSection parameters) {
        RandomUtils.populateStringProbabilityMap(this.templateProbability, parameters, "template");
        this.parameters = parameters.getConfigurationSection("block_parameters");
        this.replace = this.controller.getMaterialSetManager().fromConfig(parameters.getString("replace"));
        this.logBlockRule("Creating magic block " + StringUtils.join(RandomUtils.getValues(this.templateProbability), ","));
        return !this.templateProbability.isEmpty();
    }

    @Override
    @Nonnull
    public BlockResult onHandle(Block block, Random random, Player cause) {
        if (this.replace != null && !this.replace.testBlock(block)) {
            return BlockResult.SKIP;
        }
        String templateKey = (String)RandomUtils.weightedRandom(this.templateProbability);
        if (templateKey.equalsIgnoreCase("none")) {
            return BlockResult.SKIP;
        }
        try {
            BlockResult result = BlockResult.valueOf(templateKey.toUpperCase());
            return result;
        }
        catch (Exception result) {
            Mage mage = this.controller.getMage(cause);
            Location location = block.getLocation();
            MagicBlock magicBlock = this.controller.addMagicBlock(location, templateKey, mage.getId(), mage.getName(), this.parameters);
            String message = " magic block: " + templateKey + " at " + location.getWorld().getName() + "," + String.valueOf(location.toVector());
            message = magicBlock == null ? "Failed to create" + message : "Created" + message;
            this.controller.info(message);
            return magicBlock == null ? BlockResult.SKIP : BlockResult.REMOVE_DROPS;
        }
    }
}

